/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: Ecs_Public.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Mid Sys
    Task Resources

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
  Base:
  ---------------------------
     16      05.05.2011     sb
        removed ECAT_MBX_SET_TIMEOUT_REQ and ECAT_MBX_GET_TIMEOUT_REQ

     15      23.02.2011     uj
        introduced revision2 packets ECAT_OD_SET_OBJECT_NAME_R2_REQ_T and ECAT_OD_SET_SUBOBJECT_NAME_R2_REQ_T
        They are compatible to the old packets ECAT_OD_SET_OBJECT_NAME_REQ_T and ECAT_OD_SET_SUBOBJECT_NAME_REQ_T
        but avoids confusion about stucture elements and length values.

     14      18.02.2011     uj
        fixed Mantis 0012595: (remove unused commands from public header):
        removed unused ECAT_ESM_INIT_STATUS_CONNECTION_REQ/CNF
        and ECAT_ESM_RELEASE_STATUS_CONNECTION_REQ/CNF
        and ECAT_MBXRECV/SEND_SET_TIMEOUTS_* and ECAT_MBXRECV/SEND_GET_TIMEOUTS_* definitions
        removed obsolete ECAT_PDO_MAPPING_T stuff
        added correct structures with substructure tData, e. g. ECAT_MBX_GET_TIMEOUTS_R2_REQ_T

     13      22.02.2011  eo
        Usage of __PACKED_XXX defines replaced by __TLR_PACKED_XXX defines
        See issue #0012626: Ecs_Public.h: Header uses __PACKED_XXX instead of __TLR_PACKED_XXX

     12      17.02.2011     uj
        adjusted payload of ECAT_ESM_SII_READ_CNF packet (to the maximal available size)

     11      26.08.2008     sb
        added packets for mailbox handler indications access

     10      20.08.2008     sb
        extended ALSTATUS indications

      9      20.11.2007     sb
        moved __PACKED_POST to correct locations

      8        04.07.2007  sb
        added ECAT_ESM_* definitions for all ECATESM_* definitions

      7        03.04.2007  sb
        rewritten TxMbx handling

      6      23.03.2007     sb
        Updated source header
      1      01.06.2006     sb
        Created


  DPM:
  ---------------------------
     15      27.08.2008   sb
        added packet for online reconfigurability to update trigger configuration

     14      26.08.2008     sb
        added ECAT_DPM_SET_CONFIG packet

     13      07.02.2008     sb
        default warmstart packet is rev1
          changeable with:
          - __ECS_USE_R0_WARMSTART_REQUEST__ (for Rev0 variant)
          - __ECS_USE_R2_WARMSTART_REQUEST__ (for Rev2 variant)

     12      05.02.2008     sb
        extended warmstart message (rev2 variant)
        supported warmstart messages (rev0, rev1, rev2)

     11      15.01.2008     sb
        added definition for configuring station alias

     10      05.12.2007     sb
        added definition for reconfiguration of Sync PDI configuration

      9      22.11.2007     sb
        extended warmstart parameters

      8      20.11.2007     sb
        moved __PACKED_POST to correct locations

      7      23.03.2007   sb
        Updated source header


  CoE:
  ---------------------------
     11      16.04.2008     sb
        added packets for setobjectname/setsubobjectname

     10      22.11.2007     sb
        added new commands for application object handling on host side

      5      20.11.2007     sb
        moved __PACKED_POST to correct locations

      4      23.03.2007     sb
        update source code header

      1      01.06.2006     sb
        Created

  EoE:
  --------------------------
      3      25.06.2008     sb
        added GetIpParam request handling

      2      22.01.2008     sb
        refurbished EoE Stack design
        adapted to new protocol definition

      1      01.06.2006     sb
        Created
**************************************************************************************/

#ifndef __ECS_PUBLIC_H
#define __ECS_PUBLIC_H

#include "ecat_diag.h"
#include "ecat_error.h"

/**********************************************************************************************************************


 #######                         ##   ## ##                      ######                  ##
  #    #                       #  #   #   #                       #    #                  #                #
  #                           #   ## ##   #                       #    #                  #                #
  #  #    #####  ### #       #    ## ##   #####  ### ###          #    #  ####    #####   #  ##   #####   ####    #####
  ####   #     #  # # #     #     # # #   #    #  #   #           #####       #  #     #  #  #   #     #   #     #     #
  #  #    ###     # # #    #      # # #   #    #   ###            #       #####  #        # #    #######   #      ###
  #          ##   # # #   #       #   #   #    #   ###            #      #    #  #        ###    #         #         ##
  #    # #     #  # # #  #        #   #   #    #  #   #           #      #    #  #     #  #  #   #     #   #  #  #     #
 #######  #####  ## # ##         ### ### ######  ### ###         ####     #### #  #####  ##   ##  #####     ##    #####


*/

/***************************************************************************************/
/* Ecat Esm public, constants */


#define ECAT_ESM_PROCESS_QUEUE_NAME "ECAT_ESM_QUE"
#define ECAT_MBX_PROCESS_QUEUE_NAME "ECAT_MBX_QUE"
#define ECAT_MBX_SEND_PROCESS_QUEUE_NAME "ECAT_MBXS_QUE"

/*
 * ALEVENT/ALSTATUS state definitions
 */


#define ECAT_AL_STATE_INIT (0x01)
#define ECAT_AL_STATE_PRE_OPERATIONAL (0x02)
#define ECAT_AL_STATE_BOOTSTRAP_MODE (0x03)
#define ECAT_AL_STATE_SAFE_OPERATIONAL (0x04)
#define ECAT_AL_STATE_OPERATIONAL (0x08)


/*
 * Definitions of all available commands
 */


/*
** Summary of EtherCAT commands
*/


#define ECAT_MAILBOX_IND                               0x00001900
#define ECAT_MAILBOX_RES                               0x00001901

#define ECAT_MAILBOX_ADDTYPE_REQ                       0x00001902
#define ECAT_MAILBOX_ADDTYPE_CNF                       0x00001903
#define ECAT_COE_ADDSERVICE_REQ                        0x00001904
#define ECAT_COE_ADDSERVICE_CNF                        0x00001905
#define ECAT_MAILBOX_SEND_REQ                          0x00001906
#define ECAT_MAILBOX_SEND_CNF                          0x00001907
#define ECAT_MAILBOX_REMTYPE_REQ                       0x0000190C
#define ECAT_MAILBOX_REMTYPE_CNF                       0x0000190D

#define ECAT_ESM_SII_WRITE_REQ                         0x00001912
#define ECAT_ESM_SII_WRITE_CNF                         0x00001913

#define ECAT_ESM_SII_READ_REQ                          0x00001914
#define ECAT_ESM_SII_READ_CNF                          0x00001915

/* Deprecated commands - only for legacy compatibility.
 * Use equivalent ECAT_ESM_SII_WRITE_IND defines below instead.
 */
#define ECAT_ESM_SII_UPDATE_VENDOR_DATA_IND            0x00001916
#define ECAT_ESM_SII_UPDATE_VENDOR_DATA_RES            0x00001917

/* SII signaling */
#define ECAT_ESM_SII_WRITE_IND                         0x00001B80
#define ECAT_ESM_SII_WRITE_RES                         0x00001B81

#define ECAT_ESM_SII_WRITE_IND_REGISTER_REQ            0x00001B82
#define ECAT_ESM_SII_WRITE_IND_REGISTER_CNF            0x00001B83

#define ECAT_ESM_SII_WRITE_IND_UNREGISTER_REQ          0x00001B84
#define ECAT_ESM_SII_WRITE_IND_UNREGISTER_CNF          0x00001B85


#define ECAT_ESM_SII_WRITE_VENDOR_DATA_REQ             0x00001918
#define ECAT_ESM_SII_WRITE_VENDOR_DATA_CNF             0x00001919


/* Deprecated defines - only for legacy compatibility.
 * Use equivalent ALSTATUS defines below instead.
 */
#define ECAT_ESM_ALCONTROL_START                       0x00001960
#define ECAT_ESM_ALCONTROL_INIT_IND                    0x00001962
#define ECAT_ESM_ALCONTROL_INIT_RES                    0x00001963
#define ECAT_ESM_ALCONTROL_PRE_OPERATIONAL_IND         0x00001964
#define ECAT_ESM_ALCONTROL_PRE_OPERATIONAL_RES         0x00001965
#define ECAT_ESM_ALCONTROL_BOOTSTRAP_IND               0x00001966
#define ECAT_ESM_ALCONTROL_BOOTSTRAP_RES               0x00001967
#define ECAT_ESM_ALCONTROL_SAFE_OPERATIONAL_IND        0x00001968
#define ECAT_ESM_ALCONTROL_SAFE_OPERATIONAL_RES        0x00001969
#define ECAT_ESM_ALCONTROL_OPERATIONAL_IND             0x00001970
#define ECAT_ESM_ALCONTROL_OPERATIONAL_RES             0x00001971
#define ECAT_ESM_ALCONTROL_END                         0x0000197F

#define ECAT_ESM_ALSTATUS_START                        0x00001960
#define ECAT_ESM_ALSTATUS_INIT_IND                     0x00001962
#define ECAT_ESM_ALSTATUS_INIT_RES                     0x00001963
#define ECAT_ESM_ALSTATUS_PRE_OPERATIONAL_IND          0x00001964
#define ECAT_ESM_ALSTATUS_PRE_OPERATIONAL_RES          0x00001965
#define ECAT_ESM_ALSTATUS_BOOTSTRAP_IND                0x00001966
#define ECAT_ESM_ALSTATUS_BOOTSTRAP_RES                0x00001967
#define ECAT_ESM_ALSTATUS_SAFE_OPERATIONAL_IND         0x00001968
#define ECAT_ESM_ALSTATUS_SAFE_OPERATIONAL_RES         0x00001969
#define ECAT_ESM_ALSTATUS_OPERATIONAL_IND              0x00001970
#define ECAT_ESM_ALSTATUS_OPERATIONAL_RES              0x00001971
#define ECAT_ESM_ALSTATUS_END                          0x0000197F


#define ECAT_ESM_SETINIT_IND                           0x00001980
#define ECAT_ESM_SETINIT_RES                           0x00001981

/* This is an old command for backward compability, use the general command RCX_REGISTER_APP_REQ (0x2F10) instead */
#define ECAT_ESM_REGISTERNOTIFY_REQ                    0x00001982
#define ECAT_ESM_REGISTERNOTIFY_CNF                    0x00001983

#define ECAT_ESM_START_PROCDATA_INPUT_IND              0x00001984
#define ECAT_ESM_START_PROCDATA_INPUT_RES              0x00001985
#define ECAT_ESM_STOP_PROCDATA_INPUT_IND               0x00001986
#define ECAT_ESM_STOP_PROCDATA_INPUT_RES               0x00001987
#define ECAT_ESM_START_PROCDATA_OUTPUT_IND             0x00001988
#define ECAT_ESM_START_PROCDATA_OUTPUT_RES             0x00001989
#define ECAT_ESM_STOP_PROCDATA_OUTPUT_IND              0x0000198A
#define ECAT_ESM_STOP_PROCDATA_OUTPUT_RES              0x0000198B

/* This is an old command for backward compability, use the general command RCX_UNREGISTER_APP_REQ (0x2F12) instead */
#define ECAT_ESM_UNREGISTERNOTIFY_REQ                  0x0000198C
#define ECAT_ESM_UNREGISTERNOTIFY_CNF                  0x0000198D

#define ECAT_ESM_INIT_COMPLETE_IND                     0x0000198E
#define ECAT_ESM_INIT_COMPLETE_RES                     0x0000198F

#define ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_REQ     0x00001990
#define ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_CNF     0x00001991

#define ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_REQ   0x00001992
#define ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_CNF   0x00001993

/* bootup error indication */
#define ECAT_BOOTUP_ERROR_IND                          0x00001B66
#define ECAT_BOOTUP_ERROR_RES                          0x00001B67

/* Confirmed AL control/AL status service */
#define ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_REQ          0x00001B18
#define ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_CNF          0x00001B19
#define ECAT_ESM_CLR_QUEUE_CNF_AL_CONTROL_REQ          0x00001B1A
#define ECAT_ESM_CLR_QUEUE_CNF_AL_CONTROL_CNF          0x00001B1B
#define ECAT_ESM_ALCONTROL_CHANGE_IND                  0x00001B1C
#define ECAT_ESM_ALCONTROL_CHANGE_RES                  0x00001B1D
#define ECAT_ESM_ALSTATUS_CHANGE_REQ                   0x00001B1E
#define ECAT_ESM_ALSTATUS_CHANGE_CNF                   0x00001B1F

#define ECAT_ESM_SET_AL_STATUS_REQ                     0x00001B48
#define ECAT_ESM_SET_AL_STATUS_CNF                     0x00001B49


#define ECAT_ESM_SET_PREOP_CHECK_FN_REQ                0x00001BFA
#define ECAT_ESM_SET_PREOP_CHECK_FN_CNF                0x00001BFB
#define ECAT_ESM_SET_SAFEOP_CHECK_FN_REQ               0x00001BFC
#define ECAT_ESM_SET_SAFEOP_CHECK_FN_CNF               0x00001BFD
#define ECAT_ESM_SET_OP_CHECK_FN_REQ                   0x00001BFE
#define ECAT_ESM_SET_OP_CHECK_FN_CNF                   0x00001BFF




#define ECAT_DPM_HOST_WDG_TIMEOUT_IND                  0x00002684
#define ECAT_DPM_HOST_WDG_TIMEOUT_RES                  0x00002685
#define ECAT_DPM_HOST_WDG_CLEAR_IND                    0x00002686


/******************************************************************************/
/** @name Init Parameter for ESM to select available tasks to be waited for
 *
 * Defines all wait bits that the ESM task has to wait for
 * @{
 */

#ifndef __ECAT_ESM_FUNCTIONLIST_H
struct ECAT_READYWAIT_STATUS_tag {
  TLR_UINT32 uReadyWaitBits;
};

typedef struct ECAT_READYWAIT_STATUS_tag ECAT_READYWAIT_STATUS_T;

/** Application-definable ready wait bits */
#define ECAT_READYWAIT_APPLICATION_MASK   (0xfff00000)
/** Stack associated ready wait bits */
#define ECAT_READYWAIT_STACK_MASK         (0x000fffff)

/** Base stack ready wait bits */
#define ECAT_READYWAIT_MBX                (0x00000001)

/** CoE stack ready wait bits */
#define ECAT_READYWAIT_COE                (0x00000004)
#define ECAT_READYWAIT_COE_PDO_STAGE1     (0x00000008)
#define ECAT_READYWAIT_COE_SDO            (0x00000010)
#define ECAT_READYWAIT_COE_PDO_STAGE2     (0x00000020)

#define ECAT_READYWAIT_COE_PDO \
  (ECAT_READYWAIT_COE_PDO_STAGE1| \
   ECAT_READYWAIT_COE_PDO_STAGE2)

/** EoE stack ready wait bits */
#define ECAT_READYWAIT_EOE                (0x00000040)

/** FoE stack ready wait bits */
#define ECAT_READYWAIT_FOE                (0x00000080)

#define ECAT_READYWAIT_FOE_FH             (0x00020000)

/** VoE stack ready wait bits */
#define ECAT_READYWAIT_VOE                (0x00000100)

/** SoE stack ready wait bits */
#define ECAT_READYWAIT_SOE_SSC            (0x00000800)
#define ECAT_READYWAIT_SOE_IDN            (0x00001000)

#define ECAT_READYWAIT_COMPLETED          (0xffffffff)

/** cyclic task handlers */
#define ECAT_READYWAIT_CYCLIC_STATIC      (0x00002000)
#define ECAT_READYWAIT_CYCLIC_DYNAMIC     (0x00004000)
#define ECAT_READYWAIT_CYCLIC_DPM         (0x00008000)


#define ECAT_READYWAIT_BASE_STACK \
  ECAT_READYWAIT_MBX

#define ECAT_READYWAIT_COE_STACK \
  (ECAT_READYWAIT_COE | \
  ECAT_READYWAIT_COE_SDO)

#define ECAT_READYWAIT_EOE_STACK \
  ECAT_READYWAIT_EOE

#define ECAT_READYWAIT_VOE_STACK \
  ECAT_READYWAIT_VOE

#define ECAT_READYWAIT_FOE_STACK \
  (ECAT_READYWAIT_FOE | \
  ECAT_READYWAIT_FOE_FH)

/** app task definitions */
#define ECAT_READYWAIT_APP_TASK_1         (0x00100000)
#define ECAT_READYWAIT_APP_TASK_2         (0x00200000)
#define ECAT_READYWAIT_APP_TASK_3         (0x00400000)
#define ECAT_READYWAIT_APP_TASK_4         (0x00800000)
#define ECAT_READYWAIT_APP_TASK_5         (0x01000000)
#define ECAT_READYWAIT_APP_TASK_6         (0x02000000)
#define ECAT_READYWAIT_APP_TASK_7         (0x04000000)
#define ECAT_READYWAIT_APP_TASK_8         (0x08000000)
#define ECAT_READYWAIT_APP_TASK_9         (0x10000000)
#define ECAT_READYWAIT_APP_TASK_10        (0x20000000)
#define ECAT_READYWAIT_APP_TASK_11        (0x40000000)
#define ECAT_READYWAIT_APP_TASK_12        (0x80000000)
#endif
/** @} */



/***************************************************************************************/
/* Ecat Esm public, types */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(ECATBASE_PUBLIC)
#endif


/*
 * ALCONTROL register structure
 */

typedef __TLR_PACKED_PRE struct ECAT_ALCONTROL_tag
{
  TLR_UINT8 uState : 4;
  TLR_UINT8 fAcknowledge : 1;
  TLR_UINT8 reserved : 3;
  TLR_UINT8 bApplicationSpecific : 8;
} __TLR_PACKED_POST ECAT_ALCONTROL_T;

typedef __TLR_PACKED_PRE struct ECAT_ALSTATUS_Ttag
{
  TLR_UINT8 uState : 4;
  TLR_UINT8 fChange : 1;
  TLR_UINT8 reserved : 3;
  TLR_UINT8 bApplicationSpecific : 8;
} __TLR_PACKED_POST ECAT_ALSTATUS_T;

#define ECAT_AL_STATUS_CHANGE_CONFIRMATION (0x00)
#define ECAT_AL_STATUS_CHANGE_ERROR (0x01)

/***************************************************************************************
 * Packet ECAT_ESM_ALCONTROL_CHANGE_IND
 */

/* indication packet */

typedef __TLR_PACKED_PRE struct ECATESM_ALCONTROL_EXT_IND_DATA_Ttag
{
  ECAT_ALCONTROL_T    tAlControl;
  TLR_UINT16          usErrorLed;
  TLR_UINT16          usSyncControl;
  TLR_UINT16          usSyncImpulseLength;
  TLR_UINT32          ulSync0CycleTime;
  TLR_UINT32          ulSync1CycleTime;
  TLR_UINT8           bSyncPdiConfig;
} __TLR_PACKED_POST ECATESM_ALCONTROL_EXT_IND_DATA_T;

typedef ECATESM_ALCONTROL_EXT_IND_DATA_T ECAT_ESM_ALCONTROL_EXT_IND_DATA_T;

#define ECATESM_ALCONTROL_ERROR_LED_OFF               (0)
#define ECATESM_ALCONTROL_ERROR_LED_SOLID_ON          (1)
#define ECATESM_ALCONTROL_ERROR_LED_FLICKERING        (2)
#define ECATESM_ALCONTROL_ERROR_LED_SINGLE_FLICKER    (3)
#define ECATESM_ALCONTROL_ERROR_LED_BLINKING          (4)
#define ECATESM_ALCONTROL_ERROR_LED_SINGLE_FLASH      (5)
#define ECATESM_ALCONTROL_ERROR_LED_DOUBLE_FLASH      (6)
#define ECATESM_ALCONTROL_ERROR_LED_TRIPLE_FLASH      (7)
#define ECATESM_ALCONTROL_ERROR_LED_QUADRUPLE_FLASH   (8)
#define ECATESM_ALCONTROL_ERROR_LED_QUINTUPLE_FLASH   (9)

#define ECAT_ESM_ALCONTROL_ERROR_LED_OFF              (0)
#define ECAT_ESM_ALCONTROL_ERROR_LED_SOLID_ON         (1)
#define ECAT_ESM_ALCONTROL_ERROR_LED_FLICKERING       (2)
#define ECAT_ESM_ALCONTROL_ERROR_LED_SINGLE_FLICKER   (3)
#define ECAT_ESM_ALCONTROL_ERROR_LED_BLINKING         (4)
#define ECAT_ESM_ALCONTROL_ERROR_LED_SINGLE_FLASH     (5)
#define ECAT_ESM_ALCONTROL_ERROR_LED_DOUBLE_FLASH     (6)
#define ECAT_ESM_ALCONTROL_ERROR_LED_TRIPLE_FLASH     (7)
#define ECAT_ESM_ALCONTROL_ERROR_LED_QUADRUPLE_FLASH  (8)
#define ECAT_ESM_ALCONTROL_ERROR_LED_QUINTUPLE_FLASH  (9)

typedef struct ECATESM_ALCONTROL_EXT_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECATESM_ALCONTROL_EXT_IND_DATA_T  tData;
} ECATESM_ALCONTROL_EXT_IND_T;

typedef ECATESM_ALCONTROL_EXT_IND_T ECAT_ESM_ALCONTROL_EXT_IND_T;


/***************************************************************************************
 * Packet ECATESM_ALCONTROL_EXT_RES
 */

/* response packet */
typedef TLR_EMPTY_PACKET_T ECAT_ESM_ALCONTROL_EXT_RES_T;


/***************************************************************************************
 * Packet ECATESM_ALCONTROL_IND
 * Deprecated packet - only for legacy compatibility.
 * Use equivalent ECAT_ESM_ALSTATUS_IND_T packet below instead.
 */

/* indication packet */

typedef struct ECATESM_ALCONTROL_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;          /* packet header, defines */
  /* al control value requested by Master */
  ECAT_ALCONTROL_T    tData;
} ECATESM_ALCONTROL_IND_T;

typedef struct ECATESM_ALCONTROL_IND_Ttag   ECAT_ESM_ALCONTROL_IND_T;
typedef ECAT_ALCONTROL_T                    ECATESM_ALCONTROL_IND_DATA_T;
typedef ECAT_ALCONTROL_T                    ECAT_ESM_ALCONTROL_IND_DATA_T;

#define ECATESM_ALCONTROL_DATA_IND_SIZE sizeof(ECAT_ALCONTROL_T)
#define ECAT_ESM_ALCONTROL_DATA_IND_SIZE sizeof(ECAT_ALCONTROL_T)


/***************************************************************************************
 * Packet ECAT_ESM_ALSTATUS_IND_T
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECATESM_ALSTATUS_IND_DATA_Ttag
{
  ECAT_ALSTATUS_T     tAlStatus;
  TLR_UINT16          usErrorLed;
  TLR_UINT16          usAlStatusCode;
} __TLR_PACKED_POST ECATESM_ALSTATUS_IND_DATA_T;

typedef ECATESM_ALSTATUS_IND_DATA_T ECAT_ESM_ALSTATUS_IND_DATA_T;

#define ECATESM_ALSTATUS_ERROR_LED_OFF               (0)
#define ECATESM_ALSTATUS_ERROR_LED_SOLID_ON          (1)
#define ECATESM_ALSTATUS_ERROR_LED_FLICKERING        (2)
#define ECATESM_ALSTATUS_ERROR_LED_SINGLE_FLICKER    (3)
#define ECATESM_ALSTATUS_ERROR_LED_BLINKING          (4)
#define ECATESM_ALSTATUS_ERROR_LED_SINGLE_FLASH      (5)
#define ECATESM_ALSTATUS_ERROR_LED_DOUBLE_FLASH      (6)
#define ECATESM_ALSTATUS_ERROR_LED_TRIPLE_FLASH      (7)
#define ECATESM_ALSTATUS_ERROR_LED_QUADRUPLE_FLASH   (8)
#define ECATESM_ALSTATUS_ERROR_LED_QUINTUPLE_FLASH   (9)

#define ECAT_ESM_ALSTATUS_ERROR_LED_OFF              (0)
#define ECAT_ESM_ALSTATUS_ERROR_LED_SOLID_ON         (1)
#define ECAT_ESM_ALSTATUS_ERROR_LED_FLICKERING       (2)
#define ECAT_ESM_ALSTATUS_ERROR_LED_SINGLE_FLICKER   (3)
#define ECAT_ESM_ALSTATUS_ERROR_LED_BLINKING         (4)
#define ECAT_ESM_ALSTATUS_ERROR_LED_SINGLE_FLASH     (5)
#define ECAT_ESM_ALSTATUS_ERROR_LED_DOUBLE_FLASH     (6)
#define ECAT_ESM_ALSTATUS_ERROR_LED_TRIPLE_FLASH     (7)
#define ECAT_ESM_ALSTATUS_ERROR_LED_QUADRUPLE_FLASH  (8)
#define ECAT_ESM_ALSTATUS_ERROR_LED_QUINTUPLE_FLASH  (9)

typedef struct ECATESM_ALSTATUS_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECATESM_ALSTATUS_IND_DATA_T       tData;
} ECATESM_ALSTATUS_IND_T;

typedef ECATESM_ALSTATUS_IND_T ECAT_ESM_ALSTATUS_IND_T;


/***************************************************************************************
 * Packet ECAT_ESM_ALSTATUS_RES_T
 */

/* response packet */
typedef TLR_EMPTY_PACKET_T ECAT_ESM_ALSTATUS_RES_T;


/***************************************************************************************
 * Packet ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_REQ
 */

/* request packet legacy */
typedef struct ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_LEGACY_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
} ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_LEGACY_REQ_T;


/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_REQ_DATA_Ttag
{
  TLR_UINT32                fEnableBootToInitHandling;
} __TLR_PACKED_POST ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_REQ_DATA_T;

typedef struct ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_REQ_DATA_T  tData;
} ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_REQ_T;

/* confirmation packet */
typedef struct ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
} ECAT_ESM_SET_QUEUE_CNF_AL_CONTROL_CNF_T;

/***************************************************************************************
 * Packet ECATESM_ALSTATUS_REQ
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECATESM_ALSTATUS_REQ_DATA_Ttag
{
  /* al control value requested by Master */
  ECAT_ALSTATUS_T           tAlStatus;
  /* al status code to set */
  TLR_UINT16                usAlStatusCode;
} __TLR_PACKED_POST ECATESM_ALSTATUS_REQ_DATA_T;

typedef ECATESM_ALSTATUS_REQ_DATA_T ECAT_ESM_ALSTATUS_REQ_DATA_T;

typedef struct ECATESM_ALSTATUS_REQ_Ttag            /* request, test */
{
  TLR_PACKET_HEADER_T           tHead;          /* packet header, defines */
  ECATESM_ALSTATUS_REQ_DATA_T   tData;
} ECATESM_ALSTATUS_REQ_T;

typedef ECATESM_ALSTATUS_REQ_T ECAT_ESM_ALSTATUS_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECATESM_ALSTATUS_CNF_T;

typedef TLR_EMPTY_PACKET_T ECAT_ESM_ALSTATUS_CNF_T;


/***************************************************************************************
 * Packet ECAT_ESM_SET_AL_STATUS_REQ/ECAT_ESM_SET_AL_STATUS_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_ESM_SET_AL_STATUS_REQ_DATA_Ttag
{
  /* al status requested by slave application */
  TLR_UINT8                                       bAlStatus;
  TLR_UINT8                                       bErrorLedState;
  TLR_UINT16                                      usAlStatusCode;
} __TLR_PACKED_POST ECAT_ESM_SET_AL_STATUS_REQ_DATA_T;

typedef struct ECAT_ESM_CHANGE_SET_AL_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  ECAT_ESM_SET_AL_STATUS_REQ_DATA_T               tData;
} ECAT_ESM_SET_AL_STATUS_REQ_T;

/* confirmation packet */
typedef struct ECAT_ESM_SET_AL_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} ECAT_ESM_SET_AL_STATUS_CNF_T;


/***************************************************************************************
 * Packet ECAT_ESM_SETINIT_IND
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECATESM_SETINIT_IND_DATA_Ttag
{
  /* ready bits to set */
  TLR_UINT32 ulReadyBits;
} __TLR_PACKED_POST ECATESM_SETINIT_IND_DATA_T;

typedef ECATESM_SETINIT_IND_DATA_T ECAT_ESM_SETINIT_IND_DATA_T;

typedef struct ECATESM_SETINIT_IND_Ttag              /* set ESM to init state by completing ready bits */
{
  TLR_PACKET_HEADER_T        tHead;          /* packet header, defines */
  ECATESM_SETINIT_IND_DATA_T tData;
} ECATESM_SETINIT_IND_T;

typedef ECATESM_SETINIT_IND_T ECAT_ESM_SETINIT_IND_T;

#define ECATESM_SETINIT_DATA_IND_SIZE sizeof(ECATESM_SETINIT_IND_DATA_T)
#define ECAT_ESM_SETINIT_DATA_IND_SIZE sizeof(ECAT_ESM_SETINIT_IND_DATA_T)

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_ESM_SETINIT_RES_T;

/***************************************************************************************
 * Packet ECAT_ESM_INIT_COMPLETE_IND/ECAT_ESM_INIT_COMPLETE_RES
 */

/* indication packet */
typedef TLR_EMPTY_PACKET_T ECAT_ESM_INIT_COMPLETE_IND_T;

/* response packet */
typedef TLR_EMPTY_PACKET_T ECAT_ESM_INIT_COMPLETE_RES_T;

/***************************************************************************************
 * Packet ECAT_ESM_REGISTERNOTIFY_REQ/ECAT_ESM_REGISTERNOTIFY_CNF
   This is an old command for backward compability, use the general command RCX_REGISTER_APP_REQ (0x2F10) instead
 */

/* request packet */

typedef TLR_EMPTY_PACKET_T ECATESM_REGISTERNOTIFY_REQ_T;
typedef ECATESM_REGISTERNOTIFY_REQ_T ECAT_ESM_REGISTERNOTIFY_REQ_T;

#define ECATESM_REGISTERNOTIFY_DATA_REQ_SIZE (0)
#define ECAT_ESM_REGISTERNOTIFY_DATA_REQ_SIZE (0)

/* confirmation packet */

typedef struct ECATESM_REGISTERNOTIFY_CNF_DATA_Ttag
{
  /* handle to identify for unregister */
  TLR_UINT32 ulHandle;
} ECATESM_REGISTERNOTIFY_CNF_DATA_T;

typedef ECATESM_REGISTERNOTIFY_CNF_DATA_T ECAT_ESM_REGISTERNOTIFY_CNF_DATA_T;

typedef struct ECATESM_REGISTERNOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;          /* packet header, defines */
  ECATESM_REGISTERNOTIFY_CNF_DATA_T tData;
} ECATESM_REGISTERNOTIFY_CNF_T;

typedef ECATESM_REGISTERNOTIFY_CNF_T ECAT_ESM_REGISTERNOTIFY_CNF_T;

/***************************************************************************************
 * Packet ECATESM_UNREGISTERNOTIFY_REQ/ECATESM_UNREGISTERNOTIFY_CNF
   This is an old command for backward compability, use the general command RCX_UNREGISTER_APP_REQ (0x2F12) instead
 */

/* request packet */

typedef struct ECATESM_UNREGISTERNOTIFY_REQ_DATA_Ttag
{
  /* handle to identify for unregister */
  TLR_UINT32 ulHandle;
} ECATESM_UNREGISTERNOTIFY_REQ_DATA_T;

typedef ECATESM_UNREGISTERNOTIFY_REQ_DATA_T ECAT_ESM_UNREGISTERNOTIFY_REQ_DATA_T;

typedef struct ECATESM_UNREGISTERNOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;          /* packet header, defines */
  ECATESM_UNREGISTERNOTIFY_REQ_DATA_T tData;
} ECATESM_UNREGISTERNOTIFY_REQ_T;

typedef ECATESM_UNREGISTERNOTIFY_REQ_T ECAT_ESM_UNREGISTERNOTIFY_REQ_T;

#define ECATESM_UNREGISTERNOTIFY_DATA_REQ_SIZE sizeof(TLR_UINT32)
#define ECAT_ESM_UNREGISTERNOTIFY_DATA_REQ_SIZE sizeof(TLR_UINT32)

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECATESM_UNREGISTERNOTIFY_CNF_T;
typedef ECATESM_UNREGISTERNOTIFY_CNF_T ECAT_ESM_UNREGISTERNOTIFY_CNF_T;

/***************************************************************************************
 * Packet ECATESM_SET_CHECK_FN_REQ/ECATESM_SET_CHECK_FN_CNF
 */

/* request packet */

typedef struct ECATESM_SET_CHECK_FN_REQ_DATA_Ttag
{
  /* checks whether the condition for the state-change is valid */
  TLR_UINT16 (*fnCheckFn)(
    TLR_HANDLE      hInterface,
    TLR_UINT16*     pusErrorCode,
    TLR_UINT8*      bErrorRegister,
    TLR_UINT8*      abDiagnosticData,
    TLR_VOID*       pvUserData);
  /** private data for function */
  TLR_VOID*   pvUserData;
} ECATESM_SET_CHECK_FN_REQ_DATA_T;

typedef ECATESM_SET_CHECK_FN_REQ_DATA_T ECAT_ESM_SET_CHECK_FN_REQ_DATA_T;

typedef struct ECATESM_SET_CHECK_FN_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECATESM_SET_CHECK_FN_REQ_DATA_T     tData;
} ECATESM_SET_CHECK_FN_REQ_T;

typedef ECATESM_SET_CHECK_FN_REQ_T ECAT_ESM_SET_CHECK_FN_REQ_T;

/* additional defines for packets */
typedef struct ECATESM_SET_CHECK_FN_REQ_Ttag ECATESM_SET_PREOP_CHECK_FN_REQ_T;
typedef struct ECATESM_SET_CHECK_FN_REQ_Ttag ECATESM_SET_SAFEOP_CHECK_FN_REQ_T;
typedef struct ECATESM_SET_CHECK_FN_REQ_Ttag ECATESM_SET_OP_FN_REQ_T;

typedef ECATESM_SET_PREOP_CHECK_FN_REQ_T  ECAT_ESM_SET_PREOP_CHECK_FN_REQ_T;
typedef ECATESM_SET_SAFEOP_CHECK_FN_REQ_T ECAT_ESM_SET_SAFEOP_CHECK_FN_REQ_T;
typedef ECATESM_SET_OP_FN_REQ_T           ECAT_ESM_SET_OP_FN_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECATESM_SET_CHECK_FN_CNF_T;
typedef TLR_EMPTY_PACKET_T ECATESM_SET_PREOP_CHECK_FN_CNF_T;
typedef TLR_EMPTY_PACKET_T ECATESM_SET_SAFEOP_CHECK_FN_CNF_T;
typedef TLR_EMPTY_PACKET_T ECATESM_SET_OP_CHECK_FN_CNF_T;

typedef TLR_EMPTY_PACKET_T ECAT_ESM_SET_CHECK_FN_CNF_T;
typedef TLR_EMPTY_PACKET_T ECAT_ESM_SET_PREOP_CHECK_FN_CNF_T;
typedef TLR_EMPTY_PACKET_T ECAT_ESM_SET_SAFEOP_CHECK_FN_CNF_T;
typedef TLR_EMPTY_PACKET_T ECAT_ESM_SET_OP_CHECK_FN_CNF_T;

/***************************************************************************************
 * Packet ECAT_ESM_SII_UPDATE_VENDOR_DATA_IND
 *
 * Deprecated packet - only for legacy compatibility.
 * Use ECAT_ESM_SII_WRITE_IND packet below instead.
 */

/* indication packet */

typedef __TLR_PACKED_PRE struct ECAT_ESM_SII_UPDATE_VENDOR_DATA_IND_DATA_Ttag
{
  TLR_UINT32      ulVendorId;
  TLR_UINT32      ulProductCode;
  TLR_UINT32      ulRevisionNumber;
  TLR_UINT32      ulSerialNumber;
} __TLR_PACKED_POST ECAT_ESM_SII_UPDATE_VENDOR_DATA_IND_DATA_T;

typedef struct ECAT_ESM_SII_UPDATE_VENDOR_DATA_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_ESM_SII_UPDATE_VENDOR_DATA_IND_DATA_T  tData;
} ECAT_ESM_SII_UPDATE_VENDOR_DATA_IND_T;


/***************************************************************************************
 * Packet ECAT_ESM_SII_UPDATE_VENDOR_DATA_RES
 */

/* response packet */
typedef TLR_EMPTY_PACKET_T ECAT_ESM_SII_UPDATE_VENDOR_DATA_RES_T;


/***************************************************************************************
 * Packet ECAT_ESM_SII_WRITE_IND/ECAT_ESM_SII_WRITE_RES
 */

/* indication packet */

typedef __TLR_PACKED_PRE struct ECAT_ESM_SII_WRITE_IND_DATA_Ttag
{
  TLR_UINT32                                      ulSiiWriteStartAddress;
  TLR_UINT8                                       abData[2];          /* actual length => ulLen - sizeof(TLR_UINT32) */
} __TLR_PACKED_POST ECAT_ESM_SII_WRITE_IND_DATA_T;

typedef struct ECAT_ESM_SII_WRITE_IND_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  ECAT_ESM_SII_WRITE_IND_DATA_T                   tData;
} ECAT_ESM_SII_WRITE_IND_T;

/* response packet */

typedef struct ECAT_ESM_SII_WRITE_RES_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} ECAT_ESM_SII_WRITE_RES_T;


/***************************************************************************************
 * Packet ECAT_ESM_SII_WRITE_IND_REGISTER_REQ/ECAT_ESM_SII_WRITE_IND_REGISTER_CNF
 */

typedef struct ECAT_ESM_SII_WRITE_IND_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} ECAT_ESM_SII_WRITE_IND_REGISTER_REQ_T;

/* confirmation packet */
typedef struct ECAT_ESM_SII_WRITE_IND_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} ECAT_ESM_SII_WRITE_IND_REGISTER_CNF_T;


/***************************************************************************************
 * Packet ECAT_ESM_SII_WRITE_IND_UNREGISTER_REQ/ECAT_ESM_SII_WRITE_IND_UNREGISTER_CNF
 */

/* request packet */
typedef struct ECAT_ESM_SII_WRITE_IND_UNREGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} ECAT_ESM_SII_WRITE_IND_UNREGISTER_REQ_T;

/* confirmation packet */
typedef struct ECAT_ESM_SII_WRITE_IND_UNREGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} ECAT_ESM_SII_WRITE_IND_UNREGISTER_CNF_T;



/***************************************************************************************
 * Packet ECAT_ESM_SII_WRITE_VENDOR_DATA_REQ/ECAT_ESM_SII_WRITE_VENDOR_DATA_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_ESM_SII_WRITE_VENDOR_DATA_REQ_DATA_Ttag
{
  TLR_UINT32      ulVendorId;
  TLR_UINT32      ulProductCode;
  TLR_UINT32      ulRevisionNumber;
  TLR_UINT32      ulSerialNumber;
} __TLR_PACKED_POST ECAT_ESM_SII_WRITE_VENDOR_DATA_REQ_DATA_T;

typedef struct ECAT_ESM_SII_WRITE_VENDOR_DATA_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_ESM_SII_WRITE_VENDOR_DATA_REQ_DATA_T   tData;
} ECAT_ESM_SII_WRITE_VENDOR_DATA_REQ_T;


/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_ESM_SII_WRITE_VENDOR_DATA_CNF_T;


/***************************************************************************************
 * Packet ECAT_ESM_SII_READ_REQ/ECAT_ESM_SII_READ_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_ESM_SII_READ_REQ_DATA_Ttag
{
  TLR_UINT32      ulOffset;
  TLR_UINT32      ulSize;
} __TLR_PACKED_POST ECAT_ESM_SII_READ_REQ_DATA_T;

typedef struct ECAT_ESM_SII_READ_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  ECAT_ESM_SII_READ_REQ_DATA_T    tData;
} ECAT_ESM_SII_READ_REQ_T;

/* confirmation packet */

typedef __TLR_PACKED_PRE struct ECAT_ESM_SII_READ_CNF_DATA_Ttag
{
  TLR_UINT8       abData[1556];
} __TLR_PACKED_POST ECAT_ESM_SII_READ_CNF_DATA_T;

typedef struct ECAT_ESM_SII_READ_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  ECAT_ESM_SII_READ_CNF_DATA_T    tData;
} ECAT_ESM_SII_READ_CNF_T;


/***************************************************************************************
 * Packet ECAT_ESM_SII_WRITE_REQ/ECAT_ESM_SII_WRITE_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_ESM_SII_WRITE_REQ_DATA_Ttag
{
  TLR_UINT32      ulOffset;
  /* data follows here */
} __TLR_PACKED_POST ECAT_ESM_SII_WRITE_REQ_DATA_T;

typedef struct ECAT_ESM_SII_WRITE_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  ECAT_ESM_SII_WRITE_REQ_DATA_T   tData;
} ECAT_ESM_SII_WRITE_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T        ECAT_ESM_SII_WRITE_CNF_T;


/******************************************************************************
 * Packet data mailbox timeouts
 */

__TLR_PACKED_PRE struct ECAT_MBX_TIMEOUTS_DATA_Ttag
{
  /* timer granularity in ms */
  TLR_UINT32      ulTimerGran;
  /* low traffic timeout in ms */
  TLR_UINT32      ulLowTrafficTimeout;
} __TLR_PACKED_POST;

/* typedefs of packet data */

typedef struct ECAT_MBX_TIMEOUTS_DATA_Ttag ECAT_MBX_SET_TIMEOUTS_DATA_T;
typedef struct ECAT_MBX_TIMEOUTS_DATA_Ttag ECAT_MBX_GET_TIMEOUTS_DATA_T;


/******************************************************************************
 * Packet ECAT_ESM_START_PROCDATA_INPUT_IND/ECAT_ESM_START_PROCDATA_INPUT_RES
 *
 * not usable on LFW / shared mem api
 */

/* indication packet */
typedef struct ECAT_ESM_START_PROCDATA_INPUT_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_START_PROCDATA_INPUT_IND_T;

/* response packet */
typedef struct ECAT_ESM_START_PROCDATA_INPUT_RES_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_START_PROCDATA_INPUT_RES_T;

/******************************************************************************
 * Packet ECAT_ESM_STOP_PROCDATA_INPUT_IND/ECAT_ESM_STOP_PROCDATA_INPUT_RES
 *
 * not usable on LFW / shared mem api
 */

/* indication packet */
typedef struct ECAT_ESM_STOP_PROCDATA_INPUT_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_STOP_PROCDATA_INPUT_IND_T;

/* response packet */
typedef struct ECAT_ESM_STOP_PROCDATA_INPUT_RES_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_STOP_PROCDATA_INPUT_RES_T;

/******************************************************************************
 * Packet ECAT_ESM_START_PROCDATA_OUTPUT_IND/ECAT_ESM_START_PROCDATA_OUTPUT_RES
 *
 * not usable on LFW / shared mem api
 */

/* indication packet */
typedef struct ECAT_ESM_START_PROCDATA_OUTPUT_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_START_PROCDATA_OUTPUT_IND_T;

/* response packet */
typedef struct ECAT_ESM_START_PROCDATA_OUTPUT_RES_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_START_PROCDATA_OUTPUT_RES_T;

/******************************************************************************
 * Packet ECAT_ESM_STOP_PROCDATA_OUTPUT_IND/ECAT_ESM_STOP_PROCDATA_OUTPUT_RES
 *
 * not usable on LFW / shared mem api
 */

/* indication packet */
typedef struct ECAT_ESM_STOP_PROCDATA_OUTPUT_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_STOP_PROCDATA_OUTPUT_IND_T;

/* response packet */
typedef struct ECAT_ESM_STOP_PROCDATA_OUTPUT_RES_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_STOP_PROCDATA_OUTPUT_RES_T;

/******************************************************************************
 * Packet ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_REQ/ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_CNF
 *
 * not usable on LFW / shared mem api
 *
 * single registration only
 */

/* request packet */
typedef struct ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_REQ_T;

/* confirmation packet */
typedef struct ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_REGISTER_PROCDATA_INDICATIONS_CNF_T;

/******************************************************************************
 * Packet ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_REQ/ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_CNF
 *
 * not usable on LFW / shared mem api
 *
 * single registration only
 */

/* request packet */
typedef struct ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_REQ_T;

/* confirmation packet */
typedef struct ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_ESM_UNREGISTER_PROCDATA_INDICATIONS_CNF_T;


/******************************************************************************
 * Packet ECAT_MAILBOX_ADDTYPE_REQ/ECAT_MAILBOX_ADDTYPE_CNF
 *
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_MBX_ADD_TYPE_REQ_DATA_Ttag
{
  TLR_UINT32 ulType;
} __TLR_PACKED_POST ECAT_MBX_ADD_TYPE_REQ_DATA_T;

typedef struct ECAT_MBX_ADD_TYPE_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_MBX_ADD_TYPE_REQ_DATA_T      tData;
} ECAT_MBX_ADD_TYPE_REQ_T;

/* confirmation packet */
typedef struct ECAT_MBX_ADD_TYPE_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_MBX_ADD_TYPE_CNF_T;


/******************************************************************************
 * Packet ECAT_MAILBOX_REMTYPE_REQ/ECAT_MAILBOX_REMTYPE_CNF
 *
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_MBX_REM_TYPE_REQ_DATA_Ttag
{
  TLR_UINT32 ulType;
} __TLR_PACKED_POST ECAT_MBX_REM_TYPE_REQ_DATA_T;

typedef struct ECAT_MBX_REM_TYPE_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_MBX_REM_TYPE_REQ_DATA_T      tData;
} ECAT_MBX_REM_TYPE_REQ_T;

/* confirmation packet */
typedef struct ECAT_MBX_REM_TYPE_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
} ECAT_MBX_REM_TYPE_CNF_T;


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(ECATBASE_PUBLIC)
#endif

#endif

/**********************************************************************************************************************


 #####   ######  ##   ##         ######                  ##
  #   #   #    #  #   #           #    #                  #                #
  #    #  #    #  ## ##           #    #                  #                #
  #    #  #    #  ## ##           #    #  ####    #####   #  ##   #####   ####    #####
  #    #  #####   # # #           #####       #  #     #  #  #   #     #   #     #     #
  #    #  #       # # #           #       #####  #        # #    #######   #      ###
  #    #  #       #   #           #      #    #  #        ###    #         #         ##
  #   #   #       #   #           #      #    #  #     #  #  #   #     #   #  #  #     #
 #####   ####    ### ###         ####     #### #  #####  ##   ##  #####     ##    #####


*/

/**
 * @file EcatDPM_Public.h
 *  Ecat DPM - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 */
#ifndef __ECATDPM_PUBLIC_H
#define __ECATDPM_PUBLIC_H

#define ECAT_DPM_QUEUE_NAME        "QUE_ECAT_DPM"


#define ECAT_DPM_SET_IO_SIZE_REQ                    0x00002CC0
#define ECAT_DPM_SET_IO_SIZE_CNF                    0x00002CC1

#define ECAT_DPM_WARMSTART_REQ                      0x00002CC4
#define ECAT_DPM_WARMSTART_CNF                      0x00002CC5

#define ECAT_DPM_SET_STATION_ALIAS_REQ              0x00002CC6
#define ECAT_DPM_SET_STATION_ALIAS_CNF              0x00002CC7

#define ECAT_DPM_GET_STATION_ALIAS_REQ              0x00002CC8
#define ECAT_DPM_GET_STATION_ALIAS_CNF              0x00002CC9

#define ECAT_DPM_SET_CONFIG_REQ                     0x00002CCA
#define ECAT_DPM_SET_CONFIG_CNF                     0x00002CCB
#define ECAT_DPM_SET_CONFIGURATION_REQ              0x00002CCA
#define ECAT_DPM_SET_CONFIGURATION_CNF              0x00002CCB

#define ECAT_DPM_SET_UPDATE_CFG_REQ                 0x00002CCC
#define ECAT_DPM_SET_UPDATE_CFG_CNF                 0x00002CCD

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__ECAT_DPM_PUBLIC)
#endif


/******************************************************************************
 * Packet ECAT_DPM_SET_STATION_ALIAS_REQ/ECAT_DPM_SET_STATION_ALIAS_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_DPM_SET_STATION_ALIAS_REQ_DATA_Ttag
{
  /** Configured station alias */
  TLR_UINT16 usStationAlias;
} __TLR_PACKED_POST ECAT_DPM_SET_STATION_ALIAS_REQ_DATA_T;

typedef struct ECAT_DPM_SET_STATION_ALIAS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_SET_STATION_ALIAS_REQ_DATA_T       tData;
} ECAT_DPM_SET_STATION_ALIAS_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_DPM_SET_STATION_ALIAS_CNF_T;


/******************************************************************************
 * Packet ECAT_DPM_SET_STATION_ALIAS_REQ/ECAT_DPM_SET_STATION_ALIAS_CNF
 */

/* request packet */

typedef TLR_EMPTY_PACKET_T ECAT_DPM_GET_STATION_ALIAS_REQ_T;

/* confirmation packet */

typedef __TLR_PACKED_PRE struct ECAT_DPM_GET_STATION_ALIAS_CNF_DATA_Ttag
{
  /** Configured station alias */
  TLR_UINT16 usStationAlias;
} __TLR_PACKED_POST ECAT_DPM_GET_STATION_ALIAS_CNF_DATA_T;

typedef struct ECAT_DPM_SET_STATION_ALIAS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_GET_STATION_ALIAS_CNF_DATA_T       tData;
} ECAT_DPM_GET_STATION_ALIAS_CNF_T;


/******************************************************************************
 * Packet ECAT_DPM_SET_IO_SIZE_REQ/ECAT_DPM_SET_IO_SIZE_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_DPM_SET_IO_SIZE_REQ_DATA_Ttag
{
  /** Process Data Output Size */
  TLR_UINT32 ulProcessDataOutputSize;
  /** Process Data Input Size */
  TLR_UINT32 ulProcessDataInputSize;
} __TLR_PACKED_POST ECAT_DPM_SET_IO_SIZE_REQ_DATA_T;

typedef struct ECAT_DPM_SET_IO_SIZE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_SET_IO_SIZE_REQ_DATA_T             tData;
} ECAT_DPM_SET_IO_SIZE_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_DPM_SET_IO_SIZE_CNF_T;


/******************************************************************************
 * Packet ECAT_DPM_WARMSTART_REQ/ECAT_DPM_WARMSTART_CNF
 */


/* request packet (Rev 0) */

typedef __TLR_PACKED_PRE struct ECAT_DPM_WARMSTART_OLD_REQ_DATA_Ttag
{
  /* the first four members are aligned with ECAT_ESM_WRITE_VENDOR_DATA_REQ */
  /** reserved for IO status */
  TLR_UINT32      ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32      ulWatchdogTime;
  /** Vendor Id */
  TLR_UINT32      ulVendorId;
  /** Produt code */
  TLR_UINT32      ulProductCode;
  /** Revision number */
  TLR_UINT32      ulRevisionNumber;
  /** Serial number */
  TLR_UINT32      ulSerialNumber;
  /** Process Data Output Size */
  TLR_UINT32      ulProcessDataOutputSize;
  /** Process Data Input Size */
  TLR_UINT32      ulProcessDataInputSize;
} __TLR_PACKED_POST ECAT_DPM_WARMSTART_OLD_REQ_DATA_T;

typedef struct ECAT_DPM_WARMSTART_OLD_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_WARMSTART_OLD_REQ_DATA_T           tData;
} ECAT_DPM_WARMSTART_OLD_REQ_T;

/* request packet (Rev 1) */

typedef __TLR_PACKED_PRE struct ECAT_DPM_WARMSTART_R1_REQ_DATA_Ttag
{
  /* the first four members are aligned with ECAT_ESM_WRITE_VENDOR_DATA_REQ */
  /** reserved for IO status */
  TLR_UINT32      ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32      ulWatchdogTime;
  /** Vendor Id */
  TLR_UINT32      ulVendorId;
  /** Produt code */
  TLR_UINT32      ulProductCode;
  /** Revision number */
  TLR_UINT32      ulRevisionNumber;
  /** Serial number */
  TLR_UINT32      ulSerialNumber;
  /** Process Data Output Size */
  TLR_UINT32      ulProcessDataOutputSize;
  /** Process Data Input Size */
  TLR_UINT32      ulProcessDataInputSize;
  /* structure entries before this line shall be compliant with ECAT_DPM_WARMSTART_OLD_REQ_DATA_T */

  /** Stack Configuration Flags */
  TLR_UINT32      ulStackConfigurationFlags;
  /** SII Configuration Flags */
  TLR_UINT32      ulSIIConfigurationFlags;
  /** Sync Pdi Config */
  TLR_UINT8       bSyncPdiConfig;
  /** Sync Impulse Length */
  TLR_UINT16      usSyncImpulseLength;
  /** Device Type */
  TLR_UINT32      ulDeviceType;
} __TLR_PACKED_POST ECAT_DPM_WARMSTART_R1_REQ_DATA_T;

/* request packet (Rev 2) */

typedef __TLR_PACKED_PRE struct ECAT_DPM_WARMSTART_R2_REQ_DATA_Ttag
{
  /* the first four members are aligned with ECAT_ESM_WRITE_VENDOR_DATA_REQ */
  /** reserved for IO status */
  TLR_UINT32      ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32      ulWatchdogTime;
  /** Vendor Id */
  TLR_UINT32      ulVendorId;
  /** Produt code */
  TLR_UINT32      ulProductCode;
  /** Revision number */
  TLR_UINT32      ulRevisionNumber;
  /** Serial number */
  TLR_UINT32      ulSerialNumber;
  /** Process Data Output Size */
  TLR_UINT32      ulProcessDataOutputSize;
  /** Process Data Input Size */
  TLR_UINT32      ulProcessDataInputSize;
  /* structure entries before this line shall be compliant with ECAT_DPM_WARMSTART_OLD_REQ_DATA_T */

  /** Stack Configuration Flags */
  TLR_UINT32      ulStackConfigurationFlags;
  /** SII Configuration Flags */
  TLR_UINT32      ulSIIConfigurationFlags;
  /** Sync Pdi Config */
  TLR_UINT8       bSyncPdiConfig;
  /** Sync Impulse Length */
  TLR_UINT16      usSyncImpulseLength;
  /** Device Type */
  TLR_UINT32      ulDeviceType;
  /* structure entries before this line shall be compliant with ECAT_DPM_WARMSTART_R1_REQ_DATA_T */

  /** Station Alias (0 == not in use) */
  TLR_UINT16                  usStationAlias;

  /* Sm2 Bus-Synchronous error threshold */
  TLR_UINT32                  ulSm2ErrorThreshold;

  /* Sm3 Bus-Synchronous error threshold */
  TLR_UINT32                  ulSm3ErrorThreshold;

  /* Sync Flag error threshold */
  TLR_UINT32                  ulSyncFlagErrorThreshold;

  /* Object Dictionary configuration flags (enabled by MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_SECOND_FLAG_SET, otherwise all values are ignored)
   * undefined bits must be set to zero
   */
  TLR_UINT32                  ulOdConfigurationFlags;
  /* SDO configuration flags (enabled by MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_SECOND_FLAG_SET, otherwise all values are ignored)
   * undefined bits must be set to zero
   */
  TLR_UINT32                  ulSdoConfigurationFlags;
  /* AP configuration flags (enabled by MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_SECOND_FLAG_SET, otherwise all values are ignored)
   * undefined bits must be set to zero
   */
  TLR_UINT32                  ulApConfigurationFlags;
  /* Idn dictionary configuration flags (enabled by MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_SECOND_FLAG_SET, otherwise all values are ignored)
   * undefined bits must be set to zero
   */
  TLR_UINT32                  ulIdnConfigurationFlags;
  /* SoE dictionary configuration flags (enabled by MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_SECOND_FLAG_SET, otherwise all values are ignored)
   * undefined bits must be set to zero
   */
  TLR_UINT32                  ulSoEConfigurationFlags;
  /* Set new SDO timeout (milliseconds) */
  TLR_UINT32                  ulOdIndicationTimeout;
  /* ulIdnConfigurationFlags */
  TLR_UINT32                  ulIdnIndicationTimeout;
} __TLR_PACKED_POST ECAT_DPM_WARMSTART_R2_REQ_DATA_T;

/* defines for all packets */

#define VAL_ECAT_DPM_SIZE_UNTIL_OD_CONFIGURATION_FLAGS ((unsigned long)(&(((ECAT_DPM_WARMSTART_R2_REQ_DATA_T*)0)->ulOdConfigurationFlags)))

/* SystemFlags */
#define MSK_ECAT_DPM_WARMSTART_APP_CONTROLLED 1
#define MSK_ECAT_DPM_WARMSTART_ADR_SW_ENABLE 0x00000010

/* Stack configuration flags */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_SECOND_FLAG_SET             0x00000001

#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SM2_NO_HOST_UPDATE                 0x00000004
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SM3_NO_HOST_UPDATE                 0x00000008
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SM4_NO_HOST_UPDATE                 0x00000010  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SM5_NO_HOST_UPDATE                 0x00000020  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SM6_NO_HOST_UPDATE                 0x00000040  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SM7_NO_HOST_UPDATE                 0x00000080  /* reserved for future */

#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_FREERUN_ON_SM2                 0x00000400
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_FREERUN_ON_SM3                 0x00000800
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_FREERUN_ON_SM4                 0x00001000  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_FREERUN_ON_SM5                 0x00002000  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_FREERUN_ON_SM6                 0x00004000  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_FREERUN_ON_SM7                 0x00008000  /* reserved for future */

#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_SELF_UPDATE_ON_SM2             0x00040000
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_SELF_UPDATE_ON_SM3             0x00080000
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_SELF_UPDATE_ON_SM4             0x00100000  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_SELF_UPDATE_ON_SM5             0x00200000  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_SELF_UPDATE_ON_SM6             0x00400000  /* reserved for future */
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_SET_SELF_UPDATE_ON_SM7             0x00800000  /* reserved for future */

#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_CLEAR_APPLICATION_OBJECTS          0x01000000
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_DO_NOT_CREATE_DEFAULT_OBJECTS      0x02000000

#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_SYNC_OUTPUT_CONFIG          0x04000000

#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE     0x08000000

#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_DC_MODE_1                   0x10000000
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_DC_MODE_2                   0x20000000
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_DC_MODE_3                   0x40000000
#define MSK_ECAT_DPM_WARMSTART_STACK_CFG_ENABLE_DC_MODE_4                   0x80000000

/* SII Configuration flags */
#define MSK_ECAT_DPM_WARMSTART_SII_CFG_DO_NOT_UPDATE              0x01000000
#define MSK_ECAT_DPM_WARMSTART_SII_CFG_DO_NOT_BUILD_RXPDO_INFO    0x02000000
#define MSK_ECAT_DPM_WARMSTART_SII_CFG_DO_NOT_BUILD_TXPDO_INFO    0x04000000

/* SyncPdi configuration */
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC0_OUTPUT_TYPE         0x01
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC0_POLARITY            0x02
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC0_OUTPUT_ENABLE       0x04
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC0_IRQ_ENABLE          0x08
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC1_OUTPUT_TYPE         0x10
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC1_POLARITY            0x20
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC1_OUTPUT_ENABLE       0x40
#define MSK_ECAT_DPM_WARMSTART_SYNC_PDI_SYNC1_IRQ_ENABLE          0x80


/* Object Dictionary configuration flags */
#define MSK_ECAT_DPM_WARMSTART_OD_CFG_SET_INDICATION_TIMEOUT                0x00000001

/* IDN Dictionary configuration flags */
#define MSK_ECAT_DPM_WARMSTART_IDN_CFG_SET_INDICATION_TIMEOUT               0x00000001



typedef struct ECAT_DPM_WARMSTART_R1_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_WARMSTART_R1_REQ_DATA_T            tData;
} ECAT_DPM_WARMSTART_R1_REQ_T;

typedef struct ECAT_DPM_WARMSTART_R2_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_WARMSTART_R2_REQ_DATA_T            tData;
} ECAT_DPM_WARMSTART_R2_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_DPM_WARMSTART_CNF_T;

#if defined(__ECS_USE_R1_WARMSTART_REQUEST__)
/* Rev1 warmstart packet */
typedef ECAT_DPM_WARMSTART_R1_REQ_T   ECAT_DPM_WARMSTART_REQ_T;
#elif defined(__ECS_USE_R0_WARMSTART_REQUEST__)
/* this is the old warmstart packet for applications wanting to use the old format */
typedef ECAT_DPM_WARMSTART_OLD_REQ_T   ECAT_DPM_WARMSTART_REQ_T;
#else
/* rev2 warmstart packet to be enabled by default */
typedef ECAT_DPM_WARMSTART_R2_REQ_T  ECAT_DPM_WARMSTART_REQ_T;
#endif



/******************************************************************************
 * Packet: ECS_DPM_SET_CONFIG_REQ/ECS_DPM_SET_CONFIG_CNF
 */

typedef ECAT_DPM_WARMSTART_R2_REQ_DATA_T ECAT_DPM_SET_CONFIG_REQ_DATA_T;
typedef ECAT_DPM_WARMSTART_R2_REQ_DATA_T ECAT_DPM_SET_CONFIGURATION_REQ_DATA_T;
/* same structure as Warmstart R2 packet data */

/* defines for all packets */

/* SystemFlags */
#define MSK_ECAT_DPM_SET_CONFIG_APP_CONTROLLED 1
#define MSK_ECAT_DPM_SET_CONFIG_ADR_SW_ENABLE 0x00000010

/* Stack configuration flags */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_ENABLE_SECOND_FLAG_SET             0x00000001

#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SM2_NO_HOST_UPDATE                  0x00000004
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SM3_NO_HOST_UPDATE                  0x00000008
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SM4_NO_HOST_UPDATE                  0x00000010  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SM5_NO_HOST_UPDATE                  0x00000020  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SM6_NO_HOST_UPDATE                  0x00000040  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SM7_NO_HOST_UPDATE                  0x00000080  /* reserved for future */

#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_FREERUN_ON_SM2                  0x00000400
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_FREERUN_ON_SM3                  0x00000800
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_FREERUN_ON_SM4                  0x00001000  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_FREERUN_ON_SM5                  0x00002000  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_FREERUN_ON_SM6                  0x00004000  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_FREERUN_ON_SM7                  0x00008000  /* reserved for future */

#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_SELF_UPDATE_ON_SM2              0x00040000
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_SELF_UPDATE_ON_SM3              0x00080000
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_SELF_UPDATE_ON_SM4              0x00100000  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_SELF_UPDATE_ON_SM5              0x00200000  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_SELF_UPDATE_ON_SM6              0x00400000  /* reserved for future */
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_SET_SELF_UPDATE_ON_SM7              0x00800000  /* reserved for future */

#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_CLEAR_APPLICATION_OBJECTS           0x01000000
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_DO_NOT_CREATE_DEFAULT_OBJECTS       0x02000000

#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_ENABLE_SYNC_OUTPUT_CONFIG           0x04000000

#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE      0x08000000

#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_ENABLE_DC_MODE_1                    0x10000000
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_ENABLE_DC_MODE_2                    0x20000000
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_ENABLE_DC_MODE_3                    0x40000000
#define MSK_ECAT_DPM_SET_CONFIG_STACK_CFG_ENABLE_DC_MODE_4                    0x80000000

/* SII Configuration flags */
#define MSK_ECAT_DPM_SET_CONFIG_SII_CFG_DO_NOT_UPDATE                         0x01000000
#define MSK_ECAT_DPM_SET_CONFIG_SII_CFG_DO_NOT_BUILD_RXPDO_INFO               0x02000000
#define MSK_ECAT_DPM_SET_CONFIG_SII_CFG_DO_NOT_BUILD_TXPDO_INFO               0x04000000

/* SyncPdi configuration */
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC0_OUTPUT_TYPE                    0x01
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC0_POLARITY                       0x02
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC0_OUTPUT_ENABLE                  0x04
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC0_IRQ_ENABLE                     0x08
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC1_OUTPUT_TYPE                    0x10
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC1_POLARITY                       0x20
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC1_OUTPUT_ENABLE                  0x40
#define MSK_ECAT_DPM_SET_CONFIG_SYNC_PDI_SYNC1_IRQ_ENABLE                     0x80

/* Object Dictionary configuration flags */
#define MSK_ECAT_DPM_SET_CONFIG_OD_CFG_SET_INDICATION_TIMEOUT                0x00000001

/* IDN Dictionary configuration flags */
#define MSK_ECAT_DPM_SET_CONFIG_IDN_CFG_SET_INDICATION_TIMEOUT               0x00000001

typedef struct ECAT_DPM_SET_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_SET_CONFIG_REQ_DATA_T              tData;
} ECAT_DPM_SET_CONFIG_REQ_T;

typedef ECAT_DPM_SET_CONFIG_REQ_T ECAT_DPM_SET_CONFIGURATION_REQ_T;

/* confirmation packet */

typedef struct ECAT_DPM_SET_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_DPM_SET_CONFIG_CNF_T;

typedef ECAT_DPM_SET_CONFIG_CNF_T ECAT_DPM_SET_CONFIGURATION_CNF_T;

/******************************************************************************
 * Packet: ECAT_DPM_SET_UPDATE_CFG_REQ/ECAT_DPM_SET_UPDATE_CFG_CNF
 *
 * Remarks: for use together with Confirmed AlStatus services to control internal update handling on state change PreOp->SafeOp and on 0x1c32/0x1c33 writes handled by host
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_DPM_SET_UPDATE_CFG_REQ_DATA_Ttag
{
  /* Host update on Sm2 enabled */
  TLR_BOOLEAN8                fHostTriggeredUpdateOnSm2Enabled;
  /* Host update on Sm3 enabled */
  TLR_BOOLEAN8                fHostTriggeredUpdateOnSm3Enabled;
  /* Device update trigger mode for Sm2 (see ECAT_DPM_SET_UPDATE_CFG_MODE_*) */
  TLR_UINT8                   bDeviceTriggeredUpdateOnSm2Mode;
  /* Device update trigger mode for Sm3 (see ECAT_DPM_SET_UPDATE_CFG_MODE_*) */
  TLR_UINT8                   bDeviceTriggeredUpdateOnSm3Mode;
  /* Device update trigger mode for Bus-Sync handshake
   * (see ECAT_DPM_SET_UPDATE_CFG_MODE_*)
   * (except ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_FREERUN and ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_SELF)
   */
  TLR_UINT8                   bBusSyncTrigger;
} __TLR_PACKED_POST ECAT_DPM_SET_UPDATE_CFG_REQ_DATA_T;

#define ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_FREERUN      0      /* value of fHostTriggeredUpdateOnSm* will be ignored on particular Sm */
#define ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_SELF         1      /* self-triggered means its own event e.g. Sm2 update on Sm2 event */
#define ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_SYNC0        2      /* update is handled on Sync0 event */
#define ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_SYNC1        3      /* update is handled on Sync1 event */
#define ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_SM2         34      /* update is handled on Sm2 event */
#define ECAT_DPM_SET_UPDATE_CFG_MODE_MODE_SM3         35      /* update is handled on Sm3 event */

typedef struct ECAT_DPM_SET_UPDATE_CFG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_DPM_SET_UPDATE_CFG_REQ_DATA_T          tData;
} ECAT_DPM_SET_UPDATE_CFG_REQ_T;

/* confirmation packet */
typedef struct ECAT_DPM_SET_UPDATE_CFG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_DPM_SET_UPDATE_CFG_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__ECAT_DPM_PUBLIC)
#endif

#endif
/**********************************************************************************************************************


   ####          #######         ######                  ##
  #    #          #    #          #    #                  #                #
 #                #               #    #                  #                #
 #        #####   #  #            #    #  ####    #####   #  ##   #####   ####    #####
 #       #     #  ####            #####       #  #     #  #  #   #     #   #     #     #
 #       #     #  #  #            #       #####  #        # #    #######   #      ###
 #       #     #  #               #      #    #  #        ###    #         #         ##
  #    # #     #  #    #          #      #    #  #     #  #  #   #     #   #  #  #     #
   ####   #####  #######         ####     #### #  #####  ##   ##  #####     ##    #####


*/

#ifndef __ECATCOE_PUBLIC_H
#define __ECATCOE_PUBLIC_H

/***************************************************************************************/
/* Ecat Esm public, constants */


#define ECAT_COE_PROCESS_QUEUE_NAME "ECAT_COE_QUE"
#define ECAT_SDO_PROCESS_QUEUE_NAME "ECAT_SDO_QUE"


#define ECAT_SDO_INDEX_STATION_ADDRESS (0x1100)

#define ECAT_SDO_RXPDO_MAPPING_START      (0x1600)
#define ECAT_SDO_RXPDO_MAPPING_END        (0x17FF)
#define ECAT_SDO_TXPDO_MAPPING_START      (0x1A00)
#define ECAT_SDO_TXPDO_MAPPING_END        (0x1BFF)

#define ECAT_SDO_SYNCMAN_COMM_TYPE  (0x1C00)

#define ECAT_SDO_SYNCMAN_PDO_ASSIGN(x) (0x1C10+x)

#define ECAT_SDO_SYNCMAN_START      (0x1C00)
#define ECAT_SDO_SYNCMAN_END        (0x1CFF)

#define ECAT_SDO_MEMORY_ACCESS      (0x1D00)

#define ECAT_OD_READ_PREOP          (0x0001)
#define ECAT_OD_READ_SAFEOP         (0x0002)
#define ECAT_OD_READ_OPERATIONAL    (0x0004)
#define ECAT_OD_WRITE_PREOP         (0x0008)
#define ECAT_OD_WRITE_SAFEOP        (0x0010)
#define ECAT_OD_WRITE_OPERATIONAL   (0x0020)

#define ECAT_OD_READ_INIT           (0x4000)
#define ECAT_OD_WRITE_INIT          (0x8000)

#define ECAT_OD_SDOINFO_MASK        (0x003f)

#define ECAT_OD_READ_ALL            (ECAT_OD_READ_PREOP|ECAT_OD_READ_SAFEOP|ECAT_OD_READ_OPERATIONAL|ECAT_OD_READ_INIT)
#define ECAT_OD_WRITE_ALL            (ECAT_OD_WRITE_PREOP|ECAT_OD_WRITE_SAFEOP|ECAT_OD_WRITE_OPERATIONAL|ECAT_OD_WRITE_INIT)


/* SDO download/upload access mask */
#define ECAT_SDO_ACCESS_COMPLETE          (0x0010)
#define ECAT_SDO_ACCESS_ENHANCED          (0x0020)

#define ECAT_SDO_ACCESS_TOGGLEBIT         (0x0040)
/* internal bit */
#define ECAT_SDO_ACCESS_PACKETLINK        (0x0080)

#define ECAT_SDO_ACCESS_PRIORITY_LOWEST   (0x0000)
#define ECAT_SDO_ACCESS_PRIORITY_LOW      (0x0001)
#define ECAT_SDO_ACCESS_PRIORITY_HIGH     (0x0002)
#define ECAT_SDO_ACCESS_PRIORITY_HIGHEST  (0x0003)

#define ECAT_SDO_ACCESS_PRIORITY_MASK     (0x0003)

#define ECAT_SDO_ACCESS(completeaccess,priority) \
  ((completeaccess?ECAT_SDO_ACCESS_COMPLETE:0)| \
   (priority&ECAT_SDO_ACCESS_PRIORITY_MASK))

#define ECAT_SDO_GET_ACCESS_PRIORITY(flags) \
  (flags&ECAT_SDO_ACCESS_PRIORITY_MASK)

#define ECAT_SDO_GET_ACCESS_COMPLETE(flags) \
  (flags&ECAT_SDO_ACCESS_COMPLETE)

#define ECAT_SDO_GET_ACCESS_ENHANCED(flags) \
  (flags&ECAT_SDO_ACCESS_ENHANCED)

#define ECAT_SDO_ACCESS_TOGGLE(flags) \
  (flags=((flags&ECAT_SDO_ACCESS_TOGGLEBIT)? \
          (flags&(~ECAT_SDO_ACCESS_TOGGLEBIT)): \
          (flags|ECAT_SDO_ACCESS_TOGGLEBIT)))

#define ECAT_SDO_GET_ACCESS_TOGGLE(flags) \
  (flags&ECAT_SDO_ACCESS_TOGGLEBIT)

/* ulId mask set for ECAT_OD_READ_NOTIFY_IND/ECAT_OD_WRITE_NOTIFY_IND */

#define ECAT_OD_NOTIFY_ID(index,subindex) \
  ((((TLR_UINT32)index)<<16)|((TLR_UINT32)subindex))
#define ECAT_OD_NOTIFY_ID_INDEX(ulId) \
  ((ulId&0xffff0000)>>16)
#define ECAT_OD_NOTIFY_ID_SUBINDEX(ulid) \
  ((ulId&0x000000ff))


#define ECAT_OD_DTYPE_BOOLEAN             0x0001
#define ECAT_OD_DTYPE_INTEGER8            0x0002
#define ECAT_OD_DTYPE_INTEGER16           0x0003
#define ECAT_OD_DTYPE_INTEGER32           0x0004
#define ECAT_OD_DTYPE_UNSIGNED8           0x0005
#define ECAT_OD_DTYPE_UNSIGNED16          0x0006
#define ECAT_OD_DTYPE_UNSIGNED32          0x0007
#define ECAT_OD_DTYPE_REAL32              0x0008
#define ECAT_OD_DTYPE_VISIBLE_STRING      0x0009
#define ECAT_OD_DTYPE_OCTET_STRING        0x000a
#define ECAT_OD_DTYPE_UNICODE_STRING      0x000b
#define ECAT_OD_DTYPE_TIME_OF_DAY         0x000c      /*debricated since ETG V1.1.0*/
#define ECAT_OD_DTYPE_TIME_DIFFERENCE     0x000d      /*debricated since ETG V1.1.0*/
#define ECAT_OD_DTYPE_DOMAIN              0x000f      /*debricated since ETG V1.1.0*/
#define ECAT_OD_DTYPE_INTEGER24           0x0010
#define ECAT_OD_DTYPE_REAL64              0x0011
#define ECAT_OD_DTYPE_INTEGER40           0x0012
#define ECAT_OD_DTYPE_INTEGER48           0x0013
#define ECAT_OD_DTYPE_INTEGER56           0x0014
#define ECAT_OD_DTYPE_INTEGER64           0x0015
#define ECAT_OD_DTYPE_UNSIGNED24          0x0016
#define ECAT_OD_DTYPE_UNSIGNED40          0x0018
#define ECAT_OD_DTYPE_UNSIGNED48          0x0019
#define ECAT_OD_DTYPE_UNSIGNED56          0x001a
#define ECAT_OD_DTYPE_UNSIGNED64          0x001b
#define ECAT_OD_DTYPE_GUID                0x001d
#define ECAT_OD_DTYPE_BYTE                0x001e
#define ECAT_OD_DTYPE_WORD                0x001F
#define ECAT_OD_DTYPE_DWORD               0x0020
#define ECAT_OD_DTYPE_PDO_MAPPING         0x0021
#define ECAT_OD_DTYPE_IDENTITY            0x0023
#define ECAT_OD_DTYPE_COMMAND_PAR         0x0025
#define ECAT_OD_DTYPE_IP_PAR              0x0026    /*ETG1020 V1.1.(d) says this one is reserved for compatibility reason*/
#define ECAT_OD_DTYPE_SYNC_PAR            0x0029
#define ECAT_OD_DTYPE_BITARR8             0x002D
#define ECAT_OD_DTYPE_BITARR16            0x002E
#define ECAT_OD_DTYPE_BITARR32            0x002F
#define ECAT_OD_DTYPE_BIT1                0x0030
#define ECAT_OD_DTYPE_BIT2                0x0031
#define ECAT_OD_DTYPE_BIT3                0x0032
#define ECAT_OD_DTYPE_BIT4                0x0033
#define ECAT_OD_DTYPE_BIT5                0x0034
#define ECAT_OD_DTYPE_BIT6                0x0035
#define ECAT_OD_DTYPE_BIT7                0x0036
#define ECAT_OD_DTYPE_BIT8                0x0037
#define ECAT_OD_DTYPE_ARRAY_OF_INT        0x0260
#define ECAT_OD_DTYPE_ARRAY_OF_SINT       0x0261
#define ECAT_OD_DTYPE_ARRAY_OF_DINT       0x0262
#define ECAT_OD_DTYPE_ARRAY_OF_UDINT      0x0263


#define ECAT_COE_SERVICE_START                        0x00001920
#define ECAT_COE_SERVICE_0_IND                        0x00001920
#define ECAT_COE_EMERGENCY_IND                        0x00001922
#define ECAT_COE_SDOREQUEST_IND                       0x00001924
#define ECAT_COE_SDORESPONSE_IND                      0x00001926
#define ECAT_COE_TXPDO_IND                            0x00001928
#define ECAT_COE_RXPDO_IND                            0x0000192A
#define ECAT_COE_TXPDOREMREQ_IND                      0x0000192C
#define ECAT_COE_RXPDOREMREQ_IND                      0x0000192E
#define ECAT_COE_SDOINFO_IND                          0x00001930
#define ECAT_COE_SERVICE_9_IND                        0x00001932
#define ECAT_COE_SERVICE_10_IND                       0x00001934
#define ECAT_COE_SERVICE_11_IND                       0x00001936
#define ECAT_COE_SERVICE_12_IND                       0x00001938
#define ECAT_COE_SERVICE_13_IND                       0x0000193A
#define ECAT_COE_SERVICE_14_IND                       0x0000193C
#define ECAT_COE_SERVICE_15_IND                       0x0000193E

/* EtherCAT CoE Emergency command */
#define ECAT_COE_SEND_EMERGENCY_REQ                   0x00001994
#define ECAT_COE_SEND_EMERGENCY_CNF                   0x00001995

/* EtherCAT CoE Local SDO access */
#define ECAT_LOCAL_SDO_DOWNLOAD_EXP_REQ               0x0000199C
#define ECAT_LOCAL_SDO_DOWNLOAD_EXP_CNF               0x0000199D
#define ECAT_LOCAL_SDO_UPLOAD_EXP_REQ                 0x0000199E
#define ECAT_LOCAL_SDO_UPLOAD_EXP_CNF                 0x0000199F

/* SDO Od indication timeouts */
#define ECAT_OD_SET_INDICATION_TIMEOUT_REQ            0x000019C8
#define ECAT_OD_SET_INDICATION_TIMEOUT_CNF            0x000019C9
#define ECAT_OD_GET_INDICATION_TIMEOUT_REQ            0x000019CA
#define ECAT_OD_GET_INDICATION_TIMEOUT_CNF            0x000019CB

/* EtherCAT SDO client stack commands */
#define ECAT_SDO_DOWNLOAD_EXP_REQ                     0x000019D0
#define ECAT_SDO_DOWNLOAD_EXP_CNF                     0x000019D1
#define ECAT_SDO_UPLOAD_EXP_REQ                       0x000019D2
#define ECAT_SDO_UPLOAD_EXP_CNF                       0x000019D3


#define ECAT_COE_SDO_SET_TIMEOUTS_REQ                 0x00001B26
#define ECAT_COE_SDO_SET_TIMEOUTS_CNF                 0x00001B27
#define ECAT_COE_SDO_GET_TIMEOUTS_REQ                 0x00001B46
#define ECAT_COE_SDO_GET_TIMEOUTS_CNF                 0x00001B47
/*
** Summary of EtherCAT commands part 2
*/


/* Object dictionary */
#define ECAT_OD_CREATE_OBJECT_REQ                     0x00001B00
#define ECAT_OD_CREATE_OBJECT_CNF                     0x00001B01
#define ECAT_OD_CREATE_SUBOBJECT_REQ                  0x00001B02
#define ECAT_OD_CREATE_SUBOBJECT_CNF                  0x00001B03
#define ECAT_OD_DELETE_OBJECT_REQ                     0x00001B04
#define ECAT_OD_DELETE_OBJECT_CNF                     0x00001B05
#define ECAT_OD_CREATE_DATATYPE_REQ                   0x00001B06
#define ECAT_OD_CREATE_DATATYPE_CNF                   0x00001B07
#define ECAT_OD_DELETE_DATATYPE_REQ                   0x00001B08
#define ECAT_OD_DELETE_DATATYPE_CNF                   0x00001B09

/* Object dictionary packet notify */
#define ECAT_OD_NOTIFY_REGISTER_REQ                   0x00001B10
#define ECAT_OD_NOTIFY_REGISTER_CNF                   0x00001B11
#define ECAT_OD_NOTIFY_UNREGISTER_REQ                 0x00001B12
#define ECAT_OD_NOTIFY_UNREGISTER_CNF                 0x00001B13
#define ECAT_OD_NOTIFY_READ_IND                       0x00001B14
#define ECAT_OD_NOTIFY_READ_RES                       0x00001B15
#define ECAT_OD_NOTIFY_WRITE_IND                      0x00001B16
#define ECAT_OD_NOTIFY_WRITE_RES                      0x00001B17

#define ECAT_OD_UNDEFINED_NOTIFY_REGISTER_REQ         0x00001B20
#define ECAT_OD_UNDEFINED_NOTIFY_REGISTER_CNF         0x00001B21
#define ECAT_OD_UNDEFINED_NOTIFY_UNREGISTER_REQ       0x00001B22
#define ECAT_OD_UNDEFINED_NOTIFY_UNREGISTER_CNF       0x00001B23
#define ECAT_OD_UNDEFINED_READ_PREPARE_IND            0x00001B24
#define ECAT_OD_UNDEFINED_READ_PREPARE_RES            0x00001B25
#define ECAT_OD_UNDEFINED_READ_DATA_IND               0x00001B26
#define ECAT_OD_UNDEFINED_READ_DATA_RES               0x00001B27
#define ECAT_OD_UNDEFINED_WRITE_DATA_IND              0x00001B28
#define ECAT_OD_UNDEFINED_WRITE_DATA_RES              0x00001B29

#define ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_REQ          0x00001B2A
#define ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_CNF          0x00001B2B

#define ECAT_OD_SDOINFO_REGISTER_REQ                  0x00001B30
#define ECAT_OD_SDOINFO_REGISTER_CNF                  0x00001B31
#define ECAT_OD_SDOINFO_UNREGISTER_REQ                0x00001B32
#define ECAT_OD_SDOINFO_UNREGISTER_CNF                0x00001B33
#define ECAT_OD_SDOINFO_GET_LIST_IND                  0x00001B34
#define ECAT_OD_SDOINFO_GET_LIST_RES                  0x00001B35
#define ECAT_OD_SDOINFO_GET_OBJ_DESC_IND              0x00001B36
#define ECAT_OD_SDOINFO_GET_OBJ_DESC_RES              0x00001B37
#define ECAT_OD_SDOINFO_GET_ENTRY_DESC_IND            0x00001B38
#define ECAT_OD_SDOINFO_GET_ENTRY_DESC_RES            0x00001B39

/* this command is for internal use only */
#define ECAT_OD_NOTIFY_REGISTER_RESET_REQ             0x00001B3A
#define ECAT_OD_NOTIFY_REGISTER_RESET_CNF             0x00001B3B

#define ECAT_OD_SET_OBJECT_NAME_REQ                   0x00001B3C
#define ECAT_OD_SET_OBJECT_NAME_CNF                   0x00001B3D

#define ECAT_OD_SET_SUBOBJECT_NAME_REQ                0x00001B3E
#define ECAT_OD_SET_SUBOBJECT_NAME_CNF                0x00001B3F

/***************************************************************************************/
/* Ecat CoE public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(ECATCOE_PUBLIC)
#endif


/***************************************************************************************/


/******************************************************************************
 * CoE task
 */

/******************************************************************************
 * Packet ECAT_COE_SEND_EMERGENCY_REQ/ECAT_COE_SEND_EMERGENCY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_COE_SEND_EMERGENCY_REQ_DATA_Ttag
{
  /* Station Address */
  TLR_UINT16        usStationAddress;
  /* Message Priority */
  TLR_UINT16        usPriority;
  /* CoE Error Code */
  TLR_UINT16        usErrorCode;
  /* CoE Error Register */
  TLR_UINT8         bErrorRegister;
  /* CoE Diagnostic Data */
  TLR_UINT8         abDiagnosticData[5];
} __TLR_PACKED_POST ECAT_COE_SEND_EMERGENCY_REQ_DATA_T;

typedef struct ECAT_COE_SEND_EMERGENCY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;
  ECAT_COE_SEND_EMERGENCY_REQ_DATA_T tData;
} ECAT_COE_SEND_EMERGENCY_REQ_T;

#define ECAT_COE_SEND_EMERGENCY_DATA_REQ_SIZE (sizeof(ECAT_COE_SEND_EMERGENCY_REQ_DATA_T))


/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_COE_SEND_EMERGENCY_CNF_T;


/******************************************************************************
 * SDO task
 */

/******************************************************************************
 * Packet: ECAT_OD_SET_INDICATION_TIMEOUT_REQ/ECAT_OD_SET_INDICATION_TIMEOUT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_SET_INDICATION_TIMEOUT_REQ_DATA_Ttag
{
  /* indication response timeout in milliseconds */
  TLR_UINT32                 ulTimeout;
} __TLR_PACKED_POST ECAT_OD_SET_INDICATION_TIMEOUT_REQ_DATA_T;

typedef struct ECAT_OD_SET_INDICATION_TIMEOUT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_OD_SET_INDICATION_TIMEOUT_REQ_DATA_T   tData;
} ECAT_OD_SET_INDICATION_TIMEOUT_REQ_T;

/* confirmation packet */
typedef struct ECAT_OD_SET_INDICATION_TIMEOUT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_OD_SET_INDICATION_TIMEOUT_CNF_T;

/******************************************************************************
 * Packet: ECAT_OD_GET_INDICATION_TIMEOUT_REQ/ECAT_OD_GET_INDICATION_TIMEOUT_CNF
 */

/* request packet */
typedef struct ECAT_OD_GET_INDICATION_TIMEOUT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_OD_GET_INDICATION_TIMEOUT_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_GET_INDICATION_TIMEOUT_CNF_DATA_Ttag
{
  /* indication response timeout in milliseconds */
  TLR_UINT32                 ulTimeout;
} __TLR_PACKED_POST ECAT_OD_GET_INDICATION_TIMEOUT_CNF_DATA_T;

typedef struct ECAT_OD_GET_INDICATION_TIMEOUT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_OD_GET_INDICATION_TIMEOUT_CNF_DATA_T   tData;
} ECAT_OD_GET_INDICATION_TIMEOUT_CNF_T;

/******************************************************************************
 * Packet ECAT_COE_SDO_GET_TIMEOUTS_REQ/ECAT_COE_SDO_GET_TIMEOUTS_CNF
 */

__TLR_PACKED_PRE struct ECAT_SDO_TIMEOUTS_DATA_Ttag
{
  /* SDO timer granularity */
  TLR_UINT32                  ulTimerGran;
  /* SDO client timeout value */
  TLR_UINT32                  ulSDOClientTimeout;
  /* SDO server timeout value */
  TLR_UINT32                  ulSDOServerTimeout;
} __TLR_PACKED_POST;

typedef struct ECAT_SDO_TIMEOUTS_DATA_Ttag ECAT_SDO_GET_TIMEOUTS_DATA_T;

/* request packet */

/* outdated definition ==> access via .ulLen */
typedef TLR_PACKET_HEADER_T ECAT_SDO_GET_TIMEOUTS_REQ_T;
/* this is the correct definition, the structure contains the element tHead ==> access via .tHead.ulLen */
typedef TLR_EMPTY_PACKET_T ECAT_SDO_GET_TIMEOUTS_R2_REQ_T;

/* confirmation packet */
typedef struct ECAT_SDO_GET_TIMEOUTS_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  ECAT_SDO_GET_TIMEOUTS_DATA_T  tData;
} ECAT_SDO_GET_TIMEOUTS_CNF_T;



/******************************************************************************
 * Packet ECAT_COE_SDO_SET_TIMEOUTS_REQ/ECAT_COE_SDO_SET_TIMEOUTS_CNF
 */

typedef struct ECAT_SDO_TIMEOUTS_DATA_Ttag ECAT_SDO_SET_TIMEOUTS_DATA_T;

/* request packet */

typedef struct ECAT_SDO_SET_TIMEOUTS_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  ECAT_SDO_SET_TIMEOUTS_DATA_T  tData;
} ECAT_SDO_SET_TIMEOUTS_REQ_T;

/* confirmation packet */
/* outdated definition ==> access via .ulLen */
typedef TLR_PACKET_HEADER_T ECAT_SDO_SET_TIMEOUTS_CNF_T;
/* this is the correct definition, the structure contains the element tHead ==> access via .tHead.ulLen */
typedef TLR_EMPTY_PACKET_T ECAT_SDO_SET_TIMEOUTS_R2_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_SET_OBJECT_NAME_REQ/ECAT_OD_SET_OBJECT_NAME_CNF
 */

/* request packet
 * Deprecated packet - only for legacy compatibility.
 * Use equivalent ECAT_OD_SET_OBJECT_NAME_R2_REQ_T packet below instead. */

typedef __TLR_PACKED_PRE struct ECAT_OD_SET_OBJECT_NAME_REQ_DATA_Ttag
{
  TLR_UINT16 usIndex;
  /* name follows here (terminated with a NUL character) */
} __TLR_PACKED_POST ECAT_OD_SET_OBJECT_NAME_REQ_DATA_T;

typedef struct ECAT_OD_SET_OBJECT_NAME_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;
  ECAT_OD_SET_OBJECT_NAME_REQ_DATA_T tData;
} ECAT_OD_SET_OBJECT_NAME_REQ_T;

/* new packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_SET_OBJECT_NAME_R2_REQ_DATA_Ttag
{
  TLR_UINT16 usIndex;
  /* name (terminated with a NUL character), up to 128 characters (including terminator) */
  TLR_INT8   szName[128];
} __TLR_PACKED_POST ECAT_OD_SET_OBJECT_NAME_R2_REQ_DATA_T;

typedef struct ECAT_OD_SET_OBJECT_NAME_R2_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  ECAT_OD_SET_OBJECT_NAME_R2_REQ_DATA_T tData;
} ECAT_OD_SET_OBJECT_NAME_R2_REQ_T;

/* confirmation packet */
typedef struct ECAT_OD_SET_OBJECT_NAME_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  /* the confirmation packet has no data part */
} ECAT_OD_SET_OBJECT_NAME_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_SET_SUBOBJECT_NAME_REQ/ECAT_OD_SET_SUBOBJECT_NAME_CNF
 */

/* request packet */

/* request packet
 * Deprecated packet - only for legacy compatibility.
 * Use equivalent ECAT_OD_SET_SUBOBJECT_NAME_R2_REQ_T packet below instead. */

typedef __TLR_PACKED_PRE struct ECAT_OD_SET_SUBOBJECT_NAME_REQ_DATA_Ttag
{
  TLR_UINT16          usIndex;
  TLR_UINT8           bSubIdx;
  /* name follows here (terminated with a NUL character) */
} __TLR_PACKED_POST ECAT_OD_SET_SUBOBJECT_NAME_REQ_DATA_T;

typedef struct ECAT_OD_SET_SUBOBJECT_NAME_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  ECAT_OD_SET_SUBOBJECT_NAME_REQ_DATA_T   tData;
} ECAT_OD_SET_SUBOBJECT_NAME_REQ_T;


/* new packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_SET_SUBOBJECT_NAME_R2_REQ_DATA_Ttag
{
  TLR_UINT16 usIndex;
  TLR_UINT8  bSubIdx;
  /* name (terminated with a NUL character), up to 128 characters (including terminator) */
  TLR_INT8   szName[128];
} __TLR_PACKED_POST ECAT_OD_SET_SUBOBJECT_NAME_R2_REQ_DATA_T;

typedef struct ECAT_OD_SET_SUBOBJECT_NAME_R2_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  ECAT_OD_SET_SUBOBJECT_NAME_R2_REQ_DATA_T tData;
} ECAT_OD_SET_SUBOBJECT_NAME_R2_REQ_T;


/* confirmation packet */
typedef struct ECAT_OD_SET_SUBOBJECT_NAME_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  /* the confirmation packet has no data part */
} ECAT_OD_SET_SUBOBJECT_NAME_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_CREATE_OBJECT_REQ/ECAT_OD_CREATE_OBJECT_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_OD_CREATE_OBJECT_REQ_DATA_Ttag
{
  TLR_UINT16          usIndex;
  TLR_UINT8           bNumSubObjs;
  TLR_UINT8           bMaxSubObjs;
  TLR_UINT16          usObjAccess;
  TLR_UINT8           bObjectCode;
  TLR_UINT16          usDatatype;
  /* an optional object name can be appended here (up to 100 bytes including NUL-terminator) */
} __TLR_PACKED_POST ECAT_OD_CREATE_OBJECT_REQ_DATA_T;

typedef struct ECAT_OD_CREATE_OBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_OD_CREATE_OBJECT_REQ_DATA_T    tData;
} ECAT_OD_CREATE_OBJECT_REQ_T;
#define ECAT_OD_CREATE_OBJECT_DATA_REQ_SIZE (sizeof(ECAT_OD_CREATE_OBJECT_REQ_DATA_T))


/* confirmation packet */
/* outdated definition ==> access via .ulLen */
typedef TLR_PACKET_HEADER_T ECAT_OD_CREATE_OBJECT_CNF_T;
/* this is the correct definition, the structure contains the element tHead ==> access via .tHead.ulLen */
typedef TLR_EMPTY_PACKET_T ECAT_OD_CREATE_OBJECT_R2_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_CREATE_SUBOBJECT_REQ/ECAT_OD_CREATE_SUBOBJECT_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_OD_CREATE_SUBOBJECT_REQ_DATA_Ttag
{
  TLR_UINT32          ulMode;
  TLR_UINT16          usIndex;
  TLR_UINT8           bSubIdx;
  TLR_UINT16          usDirection;
  TLR_UINT16          usSubObjAccess;
  TLR_UINT16          usDatatype;
  TLR_UINT16          usFieldLen;
  TLR_UINT32          ulRelativeAddress;
  /* an optional initialization value of the subobject data can be appended here */
} __TLR_PACKED_POST ECAT_OD_CREATE_SUBOBJECT_REQ_DATA_T;

/* values for ulMode */
/* Object data is held in a self-contained memory area */
#define ECAT_OD_SUBOBJECT_MODE_STORAGE           0
/* Object data is reflected directly from DPM block (always Read Only, only supported on DPM firmwares)
THIS MODE IS ONLY KEPT FOR COMPABILTIY REASONS. DO NOT USE IT! */
#define ECAT_OD_SUBOBJECT_MODE_IN_DPM_BLOCK      1

#define ECAT_OD_SUBOBJECT_DIRECTION_NOT_DEF  0x0
#define ECAT_OD_SUBOBJECT_DIRECTION_INPUT    0x1    //input of the device (Slave -> Master)
#define ECAT_OD_SUBOBJECT_DIRECTION_OUTPUT   0x2    //output of the device (Master -> Slave)
#define ECAT_OD_SUBOBJECT_DIRECTION_ALL      0x3

typedef struct ECAT_OD_CREATE_SUBOBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  ECAT_OD_CREATE_SUBOBJECT_REQ_DATA_T   tData;
} ECAT_OD_CREATE_SUBOBJECT_REQ_T;
#define ECAT_OD_CREATE_SUBOBJECT_DATA_REQ_SIZE (sizeof(ECAT_OD_CREATE_SUBOBJECT_REQ_DATA_T))


/* confirmation packet */
/* outdated definition ==> access via .ulLen */
typedef TLR_PACKET_HEADER_T ECAT_OD_CREATE_SUBOBJECT_CNF_T;
/* this is the correct definition, the structure contains the element tHead ==> access via .tHead.ulLen */
typedef TLR_EMPTY_PACKET_T ECAT_OD_CREATE_SUBOBJECT_R2_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_DELETE_OBJECT_REQ/ECAT_OD_DELETE_OBJECT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_DELETE_OBJECT_REQ_DATA_Ttag
{
  TLR_BOOLEAN32       fDeleteWholeObject;
  TLR_UINT32          hSender; /* unused, set to 0 */
  TLR_UINT16          usIndex;
  TLR_UINT8           bSubIdx;
} __TLR_PACKED_POST ECAT_OD_DELETE_OBJECT_REQ_DATA_T;

typedef struct ECAT_OD_DELETE_OBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_OD_DELETE_OBJECT_REQ_DATA_T  tData;
} ECAT_OD_DELETE_OBJECT_REQ_T;
#define ECAT_OD_DELETE_OBJECT_DATA_REQ_SIZE (sizeof(ECAT_OD_DELETE_OBJECT_REQ_DATA_T))


/* confirmation packet */
/* outdated definition ==> access via .ulLen */
typedef TLR_PACKET_HEADER_T ECAT_OD_DELETE_OBJECT_CNF_T;
/* this is the correct definition, the structure contains the element tHead ==> access via .tHead.ulLen */
typedef TLR_EMPTY_PACKET_T ECAT_OD_DELETE_OBJECT_R2_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_REQ/ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_REQ_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_UINT16                  usReadOnlyAccessMask;
  TLR_UINT16                  usReadWriteAccessMask;
} __TLR_PACKED_POST ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_REQ_DATA_T;

typedef struct ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_REQ_DATA_T tData;
} ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_REQ_T;

/* confirmation packet */

typedef struct ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_OD_MODIFY_SUBINDEX_0_RIGHTS_CNF_T;

/******************************************************************************
 * Packet ECAT_OD_NOTIFY_REGISTER_REQ/ECAT_OD_NOTIFY_REGISTER_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_OD_NOTIFY_REGISTER_REQ_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_BOOLEAN32               fReadNotify;
  TLR_BOOLEAN32               fWriteNotify;
} __TLR_PACKED_POST ECAT_OD_NOTIFY_REGISTER_REQ_DATA_T;

typedef struct ECAT_OD_NOTIFY_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_OD_NOTIFY_REGISTER_REQ_DATA_T  tData;
} ECAT_OD_NOTIFY_REGISTER_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_OD_NOTIFY_REGISTER_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_NOTIFY_UNREGISTER_REQ/ECAT_OD_NOTIFY_UNREGISTER_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct ECAT_OD_NOTIFY_UNREGISTER_REQ_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_BOOLEAN32               fReadNotify;  /* this parameter is ignored, set to 0 */
  TLR_BOOLEAN32               fWriteNotify; /* this parameter is ignored, set to 0 */
} __TLR_PACKED_POST ECAT_OD_NOTIFY_UNREGISTER_REQ_DATA_T;

typedef struct ECAT_OD_NOTIFY_UNREGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  ECAT_OD_NOTIFY_UNREGISTER_REQ_DATA_T  tData;
} ECAT_OD_NOTIFY_UNREGISTER_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T ECAT_OD_NOTIFY_UNREGISTER_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_NOTIFY_READ_IND
 */

/* indication packet */

typedef __TLR_PACKED_PRE struct ECAT_OD_NOTIFY_READ_IND_DATA_Ttag
{
  TLR_UINT16          usIndex;
  TLR_UINT8           bSubIdx;
  TLR_UINT32          ulExpectedDataSize;
} __TLR_PACKED_POST ECAT_OD_NOTIFY_READ_IND_DATA_T;

typedef struct ECAT_OD_NOTIFY_READ_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  ECAT_OD_NOTIFY_READ_IND_DATA_T  tData;
} ECAT_OD_NOTIFY_READ_IND_T;

#define ECAT_OD_NOTIFY_READ_DATA_IND_SIZE (sizeof(TLR_UINT16)+sizeof(TLR_UINT8))
#define ECAT_OD_NOTIFY_WRITE_DATA_IND_SIZE (sizeof(TLR_UINT16)+sizeof(TLR_UINT8))

/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_NOTIFY_READ_RES_DATA_Ttag
{
  TLR_UINT8           abData[1];
} __TLR_PACKED_POST ECAT_OD_NOTIFY_READ_RES_DATA_T;

typedef struct ECAT_OD_NOTIFY_READ_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  ECAT_OD_NOTIFY_READ_RES_DATA_T  tData;
} ECAT_OD_NOTIFY_READ_RES_T;

/******************************************************************************
 * Packet ECAT_OD_NOTIFY_WRITE_IND
 */

/* indication packet */

typedef __TLR_PACKED_PRE struct ECAT_OD_NOTIFY_WRITE_IND_DATA_Ttag
{
  TLR_UINT16          usIndex;
  TLR_UINT8           bSubIdx;
  /* data follows here */
} __TLR_PACKED_POST ECAT_OD_NOTIFY_WRITE_IND_DATA_T;

typedef struct ECAT_OD_NOTIFY_WRITE_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  ECAT_OD_NOTIFY_WRITE_IND_DATA_T tData;
} ECAT_OD_NOTIFY_WRITE_IND_T;

/* response packet */

typedef TLR_EMPTY_PACKET_T ECAT_OD_NOTIFY_WRITE_RES_T;


/******************************************************************************
 * Packet ECAT_OD_CREATE_DATATYPE_REQ/ECAT_OD_CREATE_DATATYPE_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_CREATE_DATATYPE_REQ_DATA_Ttag
{
  TLR_UINT16          usDatatype;
  TLR_UINT32          ulBitLength;
  TLR_BOOLEAN32       fVariableLength;
} __TLR_PACKED_POST ECAT_OD_CREATE_DATATYPE_REQ_DATA_T;

typedef struct ECAT_OD_CREATE_DATATYPE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  ECAT_OD_CREATE_DATATYPE_REQ_DATA_T        tData;
} ECAT_OD_CREATE_DATATYPE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_CREATE_DATATYPE_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_DELETE_DATATYPE_REQ/ECAT_OD_DELETE_DATATYPE_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_DELETE_DATATYPE_REQ_DATA_Ttag
{
  TLR_UINT16          usDatatype;
} __TLR_PACKED_POST ECAT_OD_DELETE_DATATYPE_REQ_DATA_T;

typedef struct ECAT_OD_DELETE_DATATYPE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  ECAT_OD_DELETE_DATATYPE_REQ_DATA_T        tData;
} ECAT_OD_DELETE_DATATYPE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_DELETE_DATATYPE_CNF_T;

/******************************************************************************
 * Packet ECAT_OD_UNDEFINED_NOTIFY_REGISTER_REQ/ECAT_OD_UNDEFINED_NOTIFY_REGISTER_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_UNDEFINED_NOTIFY_REGISTER_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_UNDEFINED_NOTIFY_REGISTER_CNF_T;


/******************************************************************************
 * Packet ECAT_OD_UNDEFINED_NOTIFY_UNREGISTER_REQ/ECAT_OD_UNDEFINED_NOTIFY_UNREGISTER_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_UNDEFINED_NOTIFY_UNREGISTER_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_UNDEFINED_NOTIFY_UNREGISTER_CNF_T;

/******************************************************************************
 * Packet ECAT_OD_UNDEFINED_READ_PREPARE_IND/ECAT_OD_UNDEFINED_READ_PREPARE_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_UNDEFINED_READ_PREPARE_IND_DATA_Ttag
{
  TLR_UINT16              usIndex;
  TLR_UINT8               bSubIdx;
} __TLR_PACKED_POST ECAT_OD_UNDEFINED_READ_PREPARE_IND_DATA_T;

typedef struct ECAT_OD_UNDEFINED_READ_PREPARE_IND_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  ECAT_OD_UNDEFINED_READ_PREPARE_IND_DATA_T       tData;
} ECAT_OD_UNDEFINED_READ_PREPARE_IND_T;

/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_UNREGISTER_READ_PREPARE_RES_DATA_Ttag
{
  TLR_UINT16            usDataType;
  TLR_UINT16            usFieldLength;
} __TLR_PACKED_POST ECAT_OD_UNDEFINED_READ_PREPARE_RES_DATA_T;

typedef struct ECAT_OD_UNDEFINED_READ_PREPARE_RES_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  ECAT_OD_UNDEFINED_READ_PREPARE_RES_DATA_T       tData;
} ECAT_OD_UNDEFINED_READ_PREPARE_RES_T;


/******************************************************************************
 * Packet ECAT_OD_UNDEFINED_READ_DATA_IND/ECAT_OD_UNDEFINED_READ_DATA_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_UNDEFINED_READ_DATA_IND_DATA_Ttag
{
  TLR_UINT16                usIndex;
  TLR_UINT8                 bSubIdx;
  TLR_UINT32                ulExpectedDataSize; /* in bytes */
} __TLR_PACKED_POST ECAT_OD_UNDEFINED_READ_DATA_IND_DATA_T;

typedef struct ECAT_OD_UNDEFINED_READ_DATA_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  ECAT_OD_UNDEFINED_READ_DATA_IND_DATA_T            tData;
} ECAT_OD_UNDEFINED_READ_DATA_IND_T;

/* response packet */
#define ECAT_OD_UNDEFINED_READ_DATA_MAX_BUFFER_SIZE 2048

typedef __TLR_PACKED_PRE struct ECAT_OD_UNDEFINED_READ_DATA_RES_DATA_Ttag
{
  TLR_UINT8                 abData[ECAT_OD_UNDEFINED_READ_DATA_MAX_BUFFER_SIZE]; /* dynamic array (for all compilers this way is valid */
} __TLR_PACKED_POST ECAT_OD_UNDEFINED_READ_DATA_RES_DATA_T;

typedef struct ECAT_OD_UNDEFINED_READ_DATA_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  ECAT_OD_UNDEFINED_READ_DATA_RES_DATA_T            tData;
} __TLR_PACKED_POST ECAT_OD_UNDEFINED_READ_DATA_RES_T;

/******************************************************************************
 * Packet ECAT_OD_UNDEFINED_WRITE_DATA_IND/ECAT_OD_UNDEFINED_WRITE_DATA_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_UNDEFINED_WRITE_DATA_IND_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_UINT8                   bSubIdx;
  /* actual data follows here */
} __TLR_PACKED_POST ECAT_OD_UNDEFINED_WRITE_DATA_IND_DATA_T;

typedef struct ECAT_OD_UNDEFINED_WRITE_DATA_IND_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  ECAT_OD_UNDEFINED_WRITE_DATA_IND_DATA_T               tData;
} __TLR_PACKED_POST ECAT_OD_UNDEFINED_WRITE_DATA_IND_T;


#define ECAT_OD_UNDEFINED_WRITE_DATA_MAX_BUFFER_SIZE 2048

/* response packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_UNDEFINED_WRITE_DATA_RES_T;


/******************************************************************************
 * Packet: ECAT_OD_SDOINFO_REGISTER_REQ
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_SDOINFO_REGISTER_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_SDOINFO_REGISTER_CNF_T;

/******************************************************************************
 * Packet: ECAT_OD_SDOINFO_UNREGISTER_REQ
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_SDOINFO_UNREGISTER_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_OD_SDOINFO_UNREGISTER_CNF_T;

/******************************************************************************
 * Packet: ECAT_OD_SDOINFO_GET_LIST_IND
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_SDOINFO_GET_LIST_IND_DATA_Ttag
{
  /* list type to be retrieved */
  TLR_UINT16        usListType;
} __TLR_PACKED_POST ECAT_OD_SDOINFO_GET_LIST_IND_DATA_T;

typedef struct ECAT_OD_SDOINFO_GET_LIST_IND_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  ECAT_OD_SDOINFO_GET_LIST_IND_DATA_T   tData;
} ECAT_OD_SDOINFO_GET_LIST_IND_T;

#define ECAT_OD_SDOINFO_NUM_OF_INDEX_ENTRIES    1024
/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_SDOINFO_GET_LIST_RES_DATA_Ttag
{
  /*
   * array of object indexes (array can be made larger than
   * the ECAT_OD_SDOINFO_NUM_OF_INDEX_ENTRIES by the
   * application if possible
   */
  TLR_UINT16        ausIndex[ECAT_OD_SDOINFO_NUM_OF_INDEX_ENTRIES];
} __TLR_PACKED_POST ECAT_OD_SDOINFO_GET_LIST_RES_DATA_T;

typedef struct ECAT_OD_SDOINFO_GET_LIST_RES_Ttag
{
  /* tHead.ulLen has to be equal to
   * number of object indexes * sizeof(UINT16)
   */
  TLR_PACKET_HEADER_T                   tHead;
  ECAT_OD_SDOINFO_GET_LIST_RES_DATA_T   tData;
} ECAT_OD_SDOINFO_GET_LIST_RES_T;

/******************************************************************************
 * Packet: ECAT_OD_SDOINFO_GET_OBJ_DESC_IND
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_SDOINFO_GET_OBJ_DESC_IND_DATA_Ttag
{
  /* list type to be retrieved */
  TLR_UINT16        usIndex;
} __TLR_PACKED_POST ECAT_OD_SDOINFO_GET_OBJ_DESC_IND_DATA_T;

typedef struct ECAT_OD_SDOINFO_GET_OBJ_DESC_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  ECAT_OD_SDOINFO_GET_OBJ_DESC_IND_DATA_T tData;
} ECAT_OD_SDOINFO_GET_OBJ_DESC_IND_T;

/* response packet */

#define ECAT_COE_SDOINFO_GET_OBJ_DESC_RES_MAX_NAME_SIZE 128

typedef __TLR_PACKED_PRE struct ECAT_OD_SDOINFO_GET_OBJ_DESC_RES_DATA_Ttag
{
  /* data type of object */
  TLR_UINT16                usDataType;
  /* max sub index count of object */
  TLR_UINT8                 bMaxSubindex;
  /* object code (according to IEC61158 Type 12) */
  TLR_UINT8                 bObjectCode;
  /* object name (actual usable size depends on mailbox size) */
  TLR_STR                   szName[ECAT_COE_SDOINFO_GET_OBJ_DESC_RES_MAX_NAME_SIZE];
} __TLR_PACKED_POST ECAT_OD_SDOINFO_GET_OBJ_DESC_RES_DATA_T;

#define ECAT_COE_SDOINFO_GET_OBJ_DESC_RES_DATA_HEADER_SIZE (sizeof(ECAT_OD_SDOINFO_GET_OBJ_DESC_RES_DATA_T) - ECAT_COE_SDOINFO_GET_OBJ_DESC_RES_MAX_NAME_SIZE)

typedef struct ECAT_OD_SDOINFO_GET_OBJ_DESC_RES_Ttag
{
  /* tHead.ulLen = ECAT_COE_SDOINFO_GET_OBJ_DESC_RES_DATA_HEADER_SIZE + strlen(szName) */
  TLR_PACKET_HEADER_T                     tHead;
  ECAT_OD_SDOINFO_GET_OBJ_DESC_RES_DATA_T tData;
} ECAT_OD_SDOINFO_GET_OBJ_DESC_RES_T;

/******************************************************************************
 * Packet: ECAT_OD_SDOINFO_GET_ENTRY_DESC_IND
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_OD_SDOINFO_GET_ENTRY_DESC_IND_DATA_Ttag
{
  /* value info (according to IEC61158 Type 12) */
  TLR_UINT8         bValueInfo;
  /* index */
  TLR_UINT16        usIndex;
  /* subindex */
  TLR_UINT8         bSubIndex;
} __TLR_PACKED_POST ECAT_OD_SDOINFO_GET_ENTRY_DESC_IND_DATA_T;

typedef struct ECAT_OD_SDOINFO_GET_ENTRY_DESC_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  ECAT_OD_SDOINFO_GET_ENTRY_DESC_IND_DATA_T tData;
} ECAT_OD_SDOINFO_GET_ENTRY_DESC_IND_T;

#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_VALUE_INFO_ACCESS_RIGHTS      0x01
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_VALUE_INFO_OBJECT_CATEGORY    0x02
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_VALUE_INFO_PDO_MAP_INFO       0x04
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_VALUE_INFO_UNIT_TYPE          0x08
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_VALUE_INFO_DEFAULT_VALUE      0x10
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_VALUE_INFO_MINIMUM_VALUE      0x20
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_VALUE_INFO_MAXIMUM_VALUE      0x40

/* response packet */

#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_RES_MAX_DATA_SIZE 2048

typedef __TLR_PACKED_PRE struct ECAT_OD_SDOINFO_GET_ENTRY_DESC_RES_DATA_Ttag
{
  /* value info (according to IEC61158 Type 12) */
  TLR_UINT8                 bValueInfo;
  /* data type of object */
  TLR_UINT16                usDataType;
  /* length of entry in bits */
  TLR_UINT16                usBitLength;
  /* access rights */
  TLR_UINT16                usAccessRights;
  /* data block (formatted according to IEC61158 Type 12 (actual usable size depends on mailbox size) */
  TLR_STR                   abData[ECAT_COE_SDOINFO_GET_ENTRY_DESC_RES_MAX_DATA_SIZE];
  /* order in abData (Unit Type, Default Value, Minimum Value, Maximum Value, Name of subobject) */
} __TLR_PACKED_POST ECAT_OD_SDOINFO_GET_ENTRY_DESC_RES_DATA_T;

#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_RES_DATA_HEADER_SIZE (sizeof(ECAT_OD_SDOINFO_GET_ENTRY_DESC_RES_DATA_T) - ECAT_COE_SDOINFO_GET_ENTRY_DESC_RES_MAX_DATA_SIZE)

#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_READABLE_IN_PRE_OP      0x0001
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_READABLE_IN_SAFE_OP     0x0002
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_READABLE_IN_OP          0x0004
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_WRITABLE_IN_PRE_OP      0x0008
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_WRITABLE_IN_SAFE_OP     0x0010
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_WRITABLE_IN_OP          0x0020
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_RXPDO_MAPPABLE          0x0040
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_TXPDO_MAPPABLE          0x0080
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_BACKUP_OBJECT           0x0100
#define ECAT_COE_SDOINFO_GET_ENTRY_DESC_ACCESS_RIGHTS_CONFIG_OBJECT           0x0200

typedef struct ECAT_OD_SDOINFO_GET_ENTRY_DESC_RES_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  ECAT_OD_SDOINFO_GET_ENTRY_DESC_RES_DATA_T tData;
} ECAT_OD_SDOINFO_GET_ENTRY_DESC_RES_T;


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(ECATCOE_PUBLIC)
#endif


#endif

/**********************************************************************************************************************


  #####          #######         ######                  ##
 #     #          #    #          #    #                  #                #
 #                #               #    #                  #                #
 #        #####   #  #            #    #  ####    #####   #  ##   #####   ####    #####
  #####  #     #  ####            #####       #  #     #  #  #   #     #   #     #     #
       # #     #  #  #            #       #####  #        # #    #######   #      ###
       # #     #  #               #      #    #  #        ###    #         #         ##
 #     # #     #  #    #          #      #    #  #     #  #  #   #     #   #  #  #     #
  #####   #####  #######         ####     #### #  #####  ##   ##  #####     ##    #####


*/

#ifndef __ECATSOE_PUBLIC_H
#define __ECATSOE_PUBLIC_H


#define ECAT_SOE_IDN_PROCESS_QUEUE_NAME "ECAT_SOEIDN_QUE"



/* EtherCAT SoE commands (indications used by SoE IDN and SoE SSC task) */
#define ECAT_SOE_WRITE_IND                            0x00005800
#define ECAT_SOE_WRITE_RES                            0x00005801

#define ECAT_SOE_READ_IND                             0x00005802
#define ECAT_SOE_READ_RES                             0x00005803

#define ECAT_SOE_PROCCMD_NOTIFY_REQ                   0x00005810
#define ECAT_SOE_PROCCMD_NOTIFY_CNF                   0x00005811

#define ECAT_SOE_SLAVE_INFO_REQ                       0x00005812    /* reserved for future use */
#define ECAT_SOE_SLAVE_INFO_CNF                       0x00005813


/* same commands as requests (no need for new command definitions here) */
#define ECAT_SOE_WRITE_REQ                            0x00005800
#define ECAT_SOE_WRITE_CNF                            0x00005801

#define ECAT_SOE_READ_REQ                             0x00005802
#define ECAT_SOE_READ_CNF                             0x00005803

/* SoE IDN commands */

#define ECAT_SOEIDN_CREATE_IDN_REQ                    0x00005840
#define ECAT_SOEIDN_CREATE_IDN_CNF                    0x00005841

#define ECAT_SOEIDN_DELETE_IDN_REQ                    0x00005842
#define ECAT_SOEIDN_DELETE_IDN_CNF                    0x00005843

#define ECAT_SOEIDN_REGISTER_IDN_NOTIFY_REQ           0x00005844
#define ECAT_SOEIDN_REGISTER_IDN_NOTIFY_CNF           0x00005845

#define ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_REQ         0x00005846
#define ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_CNF         0x00005847

#define ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_REQ     0x00005848
#define ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_CNF     0x00005849

#define ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_REQ   0x0000584A
#define ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_CNF   0x0000584B

#define ECAT_SOEIDN_SET_IDN_NAME_REQ                  0x0000584C
#define ECAT_SOEIDN_SET_IDN_NAME_CNF                  0x0000584D

#define ECAT_SOEIDN_SET_IDN_UNIT_REQ                  0x0000584E
#define ECAT_SOEIDN_SET_IDN_UNIT_CNF                  0x0000584F

/***************************************************************************************/
/* Ecat SoE public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(ECAT_SOE_PUBLIC)
#endif

/* definitions for bElement */
#define ECAT_SOE_IDN_ELEMENT_DATASTATE                1
#define ECAT_SOE_IDN_ELEMENT_NAME                     2
#define ECAT_SOE_IDN_ELEMENT_ATTRIBUTE                3
#define ECAT_SOE_IDN_ELEMENT_UNIT                     4
#define ECAT_SOE_IDN_ELEMENT_MINIMUM_VALUE            5
#define ECAT_SOE_IDN_ELEMENT_MAXIMUM_VALUE            6
#define ECAT_SOE_IDN_ELEMENT_OPDATA                   7
#define ECAT_SOE_IDN_ELEMENT_DEFAULT_VALUE            8

/* definitions for usDataStatus */
#define MSK_ECAT_SOE_IDN_DATA_STATUS_OPDATA_INVALID               0x0100

#define MSK_ECAT_SOE_IDN_DATA_STATUS_COMMAND_ERROR                0x0008
#define MSK_ECAT_SOE_IDN_DATA_STATUS_COMMAND_NOT_EXECUTED         0x0004
#define MSK_ECAT_SOE_IDN_DATA_STATUS_COMMAND_EXECUTION_ENABLED    0x0002
#define MSK_ECAT_SOE_IDN_DATA_STATUS_COMMAND_SET                  0x0001

/* definitions for ulAttribute */
#define MSK_ECAT_SOE_IDN_ATTR_OPDATA_WRITE_PROTECTED_IN_CP4       0x40000000
#define MSK_ECAT_SOE_IDN_ATTR_OPDATA_WRITE_PROTECTED_IN_CP3       0x20000000
#define MSK_ECAT_SOE_IDN_ATTR_OPDATA_WRITE_PROTECTED_IN_CP2       0x10000000

#define MSK_ECAT_SOE_IDN_ATTR_DECIMAL_PLACEMENT                   0x0F000000
#define SRT_ECAT_SOE_IDN_ATTR_DECIMAL_PLACEMENT                   24

#define MSK_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT                      0x00700000
#define SRT_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT                      20
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_BINARY               0x00000000
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_UNSIGNED_DECIMAL     0x00100000
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_SIGNED_DECIMAL       0x00200000
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_UNSIGNED_HEXADECIMAL 0x00300000
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_TEXT                 0x00400000
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_IDN                  0x00500000
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_FLOATING_POINT       0x00600000
#define VAL_ECAT_SOE_IDN_ATTR_DISPLAY_FORMAT_RESERVED             0x00700000

#define MSK_ECAT_SOE_IDN_ATTR_OPDATA_IS_PROC_CMD                  0x00080000

#define MSK_ECAT_SOE_IDN_ATTR_DATA_LENGTH                         0x00070000
#define SRT_ECAT_SOE_IDN_ATTR_DATA_LENGTH                         16
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_RESERVED0               0x00000000
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_TWO_BYTE                0x00010000
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_FOUR_BYTE               0x00020000
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_EIGHT_BYTE              0x00030000
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_ONE_BYTE_LIST           0x00040000
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_TWO_BYTE_LIST           0x00050000
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_FOUR_BYTE_LIST          0x00060000
#define VAL_ECAT_SOE_IDN_ATTR_DATA_LENGTH_EIGHT_BYTE_LIST         0x00070000

#define MSK_ECAT_SOE_IDN_ATTR_SCALING                             0x0000FFFF
#define SRT_ECAT_SOE_IDN_ATTR_SCALING                             0

/* additional definitions */
#define MSK_ECAT_SOE_IDN_ATTR_DATA_LENGTH_IS_LIST                 0x00040000

/******************************************************************************
 * Packet:  ECAT_SOE_WRITE_IND/ECAT_SOE_WRITE_RES
 * Packet:  ECAT_SOE_WRITE_REQ/ECAT_SOE_WRITE_CNF
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_SOE_WRITE_IND_DATA_Ttag
{
  /* unfragmentable part */
  TLR_UINT16                          usIdn;
  TLR_UINT8                           bElement;
  TLR_UINT8                           bDriveNo;
  TLR_UINT16                          usTotalLength;        /* total length of data in abData */
  /* fragmentable part */
  TLR_UINT8                           abData[1];
} __TLR_PACKED_POST ECAT_SOE_WRITE_IND_DATA_T;

#define ECAT_SOE_WRITE_IND_MIN_SIZE (sizeof(TLR_UINT16) + sizeof(TLR_UINT8) + sizeof(TLR_UINT8) + sizeof(TLR_UINT16))

typedef struct ECAT_SOE_WRITE_IND_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_SOE_WRITE_IND_DATA_T           tData;
} ECAT_SOE_WRITE_IND_T;

/* response packet */
typedef struct ECAT_SOE_WRITE_RES_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
} ECAT_SOE_WRITE_RES_T;

/* request packet */
typedef ECAT_SOE_WRITE_IND_DATA_T   ECAT_SOE_WRITE_REQ_DATA_T;
typedef ECAT_SOE_WRITE_IND_T        ECAT_SOE_WRITE_REQ_T;

#define ECAT_SOE_WRITE_REQ_MIN_SIZE ECAT_SOE_WRITE_IND_MIN_SIZE

/* confirmation packet */
typedef ECAT_SOE_WRITE_RES_T        ECAT_SOE_WRITE_CNF_T;

/* packet union */
typedef union ECAT_SOE_WRITE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;

  /* indication packet */
  ECAT_SOE_WRITE_IND_T                tInd;
  ECAT_SOE_WRITE_RES_T                tRes;

  /* request packet */
  ECAT_SOE_WRITE_REQ_T                tReq;
  ECAT_SOE_WRITE_CNF_T                tCnf;
} ECAT_SOE_WRITE_PCK_T;

/******************************************************************************
 * Packet:  ECAT_SOE_READ_IND/ECAT_SOE_READ_RES
 * Packet:  ECAT_SOE_READ_REQ/ECAT_SOE_READ_CNF
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_SOE_READ_IND_DATA_Ttag
{
  TLR_UINT16                          usIdn;
  TLR_UINT8                           bElement;
  TLR_UINT8                           bDriveNo;
  TLR_UINT16                          usMaxReadLength;      /* maximum read length needed for reducing the actually read data */
} __TLR_PACKED_POST ECAT_SOE_READ_IND_DATA_T;

typedef struct ECAT_SOE_READ_IND_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_SOE_READ_IND_DATA_T            tData;
} ECAT_SOE_READ_IND_T;

/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_SOE_READ_RES_DATA_Ttag
{
  /* unfragmentable part */
  TLR_UINT16                          usTotalLength;        /* total length of data in abData */
  /* fragmentable part */
  TLR_UINT8                           abData[1];
} __TLR_PACKED_POST ECAT_SOE_READ_RES_DATA_T;

#define ECAT_SOE_READ_RES_MIN_SIZE sizeof(TLR_UINT16)

typedef struct ECAT_SOE_READ_RES_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_SOE_READ_RES_DATA_T            tData;
} ECAT_SOE_READ_RES_T;

/* request packet */
typedef ECAT_SOE_READ_IND_DATA_T    ECAT_SOE_READ_REQ_DATA_T;
typedef ECAT_SOE_READ_IND_T         ECAT_SOE_READ_REQ_T;

/* confirmation packet */
typedef ECAT_SOE_READ_RES_DATA_T    ECAT_SOE_READ_CNF_DATA_T;
typedef ECAT_SOE_READ_RES_T         ECAT_SOE_READ_CNF_T;

#define ECAT_SOE_READ_CNF_MIN_SIZE ECAT_SOE_READ_RES_MIN_SIZE

/* packet union */
typedef union ECAT_SOE_READ_PCK_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;

  /* indication packet */
  ECAT_SOE_READ_IND_T                 tInd;
  ECAT_SOE_READ_RES_T                 tRes;

  /* request packet */
  ECAT_SOE_READ_REQ_T                 tReq;
  ECAT_SOE_READ_CNF_T                 tCnf;
} ECAT_SOE_READ_PCK_T;

/******************************************************************************
 * Packet:  ECAT_SOE_PROCCMD_NOTIFY_REQ/ECAT_SOE_PROCCMD_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOE_PROCCMD_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT16                          usIdn;
  TLR_UINT8                           bDriveNo;
  TLR_UINT16                          usDataState;
} __TLR_PACKED_POST ECAT_SOE_PROCCMD_NOTIFY_REQ_DATA_T;

typedef struct ECAT_SOE_PROCCMD_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_SOE_PROCCMD_NOTIFY_REQ_DATA_T  tData;
} ECAT_SOE_PROCCMD_NOTIFY_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOE_PROCCMD_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
} ECAT_SOE_PROCCMD_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  ECAT_SOEIDN_CREATE_IDN_REQ/ECAT_SOEIDN_CREATE_IDN_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_CREATE_IDN_REQ_DATA_Ttag
{
  /* unfragmentable part */
  TLR_UINT32                          ulTotalLength;        /* total length of data stored in abData */
  TLR_UINT16                          usIdn;
  TLR_UINT16                          usMaxListDataSize;    /* in bytes only valid on List types (including list header) */
  TLR_UINT32                          ulAttribute;
  TLR_UINT8                           bDriveNo;
  TLR_UINT8                           bValueInfo;
  TLR_UINT16                          usMaxNameLength;
  TLR_UINT16                          usMaxUnitLength;
  /* fragmentable part */
  TLR_UINT8                           abData[1];
} __TLR_PACKED_POST ECAT_SOEIDN_CREATE_IDN_REQ_DATA_T;

#define ECAT_SOEIDN_CREATE_IDN_MIN_DATA_SIZE (sizeof(ECAT_SOEIDN_CREATE_IDN_REQ_DATA_T) - sizeof(((ECAT_SOEIDN_CREATE_IDN_REQ_DATA_T*)0)->abData))

/* following values are appended in order of their definition to abData (DATASTATE, NAME, UNIT, MINIMUM, MAXIMUM, VALUE, DEFVALUE) */
#define MSK_ECAT_SOEIDN_CREATE_IDN_VALUE_INFO_DATASTATE 0x01    /* initial value */
#define MSK_ECAT_SOEIDN_CREATE_IDN_VALUE_INFO_NAME      0x02
#define MSK_ECAT_SOEIDN_CREATE_IDN_VALUE_INFO_UNIT      0x04
#define MSK_ECAT_SOEIDN_CREATE_IDN_VALUE_INFO_MINIMUM   0x08
#define MSK_ECAT_SOEIDN_CREATE_IDN_VALUE_INFO_MAXIMUM   0x10
#define MSK_ECAT_SOEIDN_CREATE_IDN_VALUE_INFO_VALUE     0x20
#define MSK_ECAT_SOEIDN_CREATE_IDN_VALUE_INFO_DEFVALUE  0x40


typedef struct ECAT_SOEIDN_CREATE_IDN_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_SOEIDN_CREATE_IDN_REQ_DATA_T   tData;
} ECAT_SOEIDN_CREATE_IDN_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_CREATE_IDN_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
} ECAT_SOEIDN_CREATE_IDN_CNF_T;

/******************************************************************************
 * Packet:  ECAT_SOEIDN_DELETE_IDN_REQ/ECAT_SOEIDN_DELETE_IDN_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_DELETE_IDN_REQ_DATA_Ttag
{
  TLR_UINT16                          usIdn;
  TLR_UINT8                           bDriveNo;
} __TLR_PACKED_POST ECAT_SOEIDN_DELETE_IDN_REQ_DATA_T;

typedef struct ECAT_SOEIDN_DELETE_IDN_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  ECAT_SOEIDN_DELETE_IDN_REQ_DATA_T   tData;
} ECAT_SOEIDN_DELETE_IDN_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_DELETE_IDN_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
} ECAT_SOEIDN_DELETE_IDN_CNF_T;


/******************************************************************************
 * Packet:  ECAT_SOEIDN_REGISTER_IDN_NOTIFY_REQ/ECAT_SOEIDN_REGISTER_IDN_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_REGISTER_IDN_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT16                          usIdn;
  TLR_UINT8                           bDriveNo;
  TLR_BOOLEAN8                        fReadNotify;
  TLR_BOOLEAN8                        fWriteNotify;
} __TLR_PACKED_POST ECAT_SOEIDN_REGISTER_IDN_NOTIFY_REQ_DATA_T;

typedef struct ECAT_SOEIDN_REGISTER_IDN_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_SOEIDN_REGISTER_IDN_NOTIFY_REQ_DATA_T  tData;
} ECAT_SOEIDN_REGISTER_IDN_NOTIFY_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_REGISTER_IDN_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_SOEIDN_REGISTER_IDN_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_REQ/ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT16                          usIdn;
  TLR_UINT8                           bDriveNo;
} __TLR_PACKED_POST ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_REQ_DATA_T;

typedef struct ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_REQ_DATA_T  tData;
} ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} ECAT_SOEIDN_UNREGISTER_IDN_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_REQ/ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT8                           bDriveNo;
} __TLR_PACKED_POST ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_REQ_DATA_T;

typedef struct ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_REQ_DATA_T    tData;
} ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_SOEIDN_REGISTER_UNDEFINED_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_REQ/ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT8                           bDriveNo;
} __TLR_PACKED_POST ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_DATA_T;

typedef struct ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_DATA_T  tData;
} ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_SOEIDN_UNREGISTER_UNDEFINED_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  ECAT_SOEIDN_SET_NAME_REQ/ECAT_SOEIDN_SET_NAME_CNF (does not support fragmentation)
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_SET_IDN_NAME_REQ_DATA_Ttag
{
  TLR_UINT8     bDriveNo;
  TLR_UINT16    usIdn;
  TLR_UINT16    usNameLength;       /* length of actual name */
  TLR_UINT16    usPad;
  TLR_STR       szName[256];        /* dynamic sized array of chars */
} __TLR_PACKED_POST ECAT_SOEIDN_SET_IDN_NAME_REQ_DATA_T;

#define ECAT_SOEIDN_SET_IDN_NAME_REQ_MIN_SIZE     (3 * sizeof(TLR_UINT16) + sizeof(TLR_UINT8))

typedef struct ECAT_SOEIDN_SET_IDN_NAME_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_SOEIDN_SET_IDN_NAME_REQ_DATA_T         tData;
} ECAT_SOEIDN_SET_IDN_NAME_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_SET_IDN_NAME_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_SOEIDN_SET_IDN_NAME_CNF_T;

/******************************************************************************
 * Packet:  ECAT_SOEIDN_SET_UNIT_REQ/ECAT_SOEIDN_SET_UNIT_CNF (does not support fragmentation)
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_SOEIDN_SET_IDN_UNIT_REQ_DATA_Ttag
{
  TLR_UINT8     bDriveNo;
  TLR_UINT16    usIdn;
  TLR_UINT16    usUnitLength;       /* length of actual unit */
  TLR_UINT16    usPad;
  TLR_STR       szUnit[256];        /* dynamic sized array of chars */
} __TLR_PACKED_POST ECAT_SOEIDN_SET_IDN_UNIT_REQ_DATA_T;

#define ECAT_SOEIDN_SET_IDN_UNIT_REQ_MIN_SIZE     (3 * sizeof(TLR_UINT16) + sizeof(TLR_UINT8))

typedef struct ECAT_SOEIDN_SET_IDN_UNIT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  ECAT_SOEIDN_SET_IDN_UNIT_REQ_DATA_T         tData;
} ECAT_SOEIDN_SET_IDN_UNIT_REQ_T;

/* confirmation packet */
typedef struct ECAT_SOEIDN_SET_IDN_UNIT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} ECAT_SOEIDN_SET_IDN_UNIT_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(ECAT_SOE_PUBLIC)
#endif


#endif

#ifndef __ECATEOE_PUBLIC_H
#define __ECATEOE_PUBLIC_H

#define ECAT_EOE_PROCESS_QUEUE_NAME "ECAT_EOE_QUE"

/* EoE IP config update */
#define ECAT_EOE_SET_NOTIFY_QUEUE_REQ               0x00001B76
#define ECAT_EOE_SET_NOTIFY_QUEUE_CNF               0x00001B77
#define ECAT_EOE_CLEAR_NOTIFY_QUEUE_REQ             0x00001B78
#define ECAT_EOE_CLEAR_NOTIFY_QUEUE_CNF             0x00001B79

#define ECAT_EOE_SET_IPPARAM_NOTIFY_QUEUE_REQ       0x00001B7A
#define ECAT_EOE_SET_IPPARAM_NOTIFY_QUEUE_CNF       0x00001B7B
#define ECAT_EOE_CLEAR_IPPARAM_NOTIFY_QUEUE_REQ     0x00001B7C
#define ECAT_EOE_CLEAR_IPPARAM_NOTIFY_QUEUE_CNF     0x00001B7D

#define ECAT_EOE_SET_IP_PARAM_IND                   0x00001B7E
#define ECAT_EOE_SET_IP_PARAM_RES                   0x00001B7F

#define ECAT_EOE_GET_IP_PARAM_IND                   0x00001B50
#define ECAT_EOE_GET_IP_PARAM_RES                   0x00001B51

/* Timeout configuration commands */
#define ECAT_EOE_SET_TIMEOUTS_REQ                   0x00001B2E
#define ECAT_EOE_SET_TIMEOUTS_CNF                   0x00001B2F
#define ECAT_EOE_GET_TIMEOUTS_REQ                   0x00001B4E
#define ECAT_EOE_GET_TIMEOUTS_CNF                   0x00001B4F


#define ECAT_EOE_FRAME_IND                          0x00001B70
#define ECAT_EOE_FRAME_RES                          0x00001B71
#define ECAT_EOE_FRAME_REQ                          0x00001B72
#define ECAT_EOE_FRAME_CNF                          0x00001B73

/* 0x1B72-0x1B7F are reserved for EoE Stack part */

typedef TLR_UINT8 ECAT_EOE_MACADDR_T[6];

/******************************************************************************
 * Packet:  ECAT_EOE_SET_NOTIFY_QUEUE_REQ/ECAT_EOE_SET_NOTIFY_QUEUE_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_SET_NOTIFY_QUEUE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_SET_NOTIFY_QUEUE_CNF_T;

/******************************************************************************
 * Packet:  ECAT_EOE_CLEAR_NOTIFY_QUEUE_REQ/ECAT_EOE_CLEAR_NOTIFY_QUEUE_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_CLEAR_NOTIFY_QUEUE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_CLEAR_NOTIFY_QUEUE_CNF_T;


/******************************************************************************
 * Packet:  ECAT_EOE_SET_IPPPARAM_NOTIFY_QUEUE_REQ/ECAT_EOE_SET_IPPARAM_NOTIFY_QUEUE_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_SET_IPPARAM_NOTIFY_QUEUE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_SET_IPPPARAM_NOTIFY_QUEUE_CNF_T;

/******************************************************************************
 * Packet:  ECAT_EOE_CLEAR_IPPARAM_NOTIFY_QUEUE_REQ/ECAT_EOE_CLEAR_IPPARAM_NOTIFY_QUEUE_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_CLEAR_IPPARAM_NOTIFY_QUEUE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_CLEAR_IPPARAM_NOTIFY_QUEUE_CNF_T;


/******************************************************************************
 * Packet: ECAT_EOE_SET_IP_PARAM_IND/ECAT_EOE_SET_IP_PARAM_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_EOE_SET_IP_PARAM_IND_DATA_Ttag
{
  TLR_UINT32              ulFlags;
  TLR_UINT8               abMacAddr[6];                 /* only valid if ECAT_EOE_SET_IP_PARAM_MAC_ADDRESS_INCLUDED         set in ulFlags */
  TLR_UINT8               abIpAddr[4];                  /* only valid if ECAT_EOE_SET_IP_PARAM_IP_ADDRESS_INCLUDED          set in ulFlags */
  TLR_UINT8               abSubnetMask[4];              /* only valid if ECAT_EOE_SET_IP_PARAM_SUBNET_MASK_INCLUDED         set in ulFlags */
  TLR_UINT8               abDefaultGateway[4];          /* only valid if ECAT_EOE_SET_IP_PARAM_DEFAULT_GATEWAY_INCLUDED     set in ulFlags */
  TLR_UINT8               abDnsServerIpAddress[4];      /* only valid if ECAT_EOE_SET_IP_PARAM_DNS_SERVER_IP_ADDR_INCLUDED  set in ulFlags */
  TLR_STR                 abDnsName[32];                /* only valid if ECAT_EOE_SET_IP_PARAM_DNS_NAME_INCLUDED            set in ulFlags */
} __TLR_PACKED_POST ECAT_EOE_SET_IP_PARAM_IND_DATA_T;

#define ECAT_EOE_SET_IP_PARAM_MAC_ADDRESS_INCLUDED        0x00000001
#define ECAT_EOE_SET_IP_PARAM_IP_ADDRESS_INCLUDED         0x00000002
#define ECAT_EOE_SET_IP_PARAM_SUBNET_MASK_INCLUDED        0x00000004
#define ECAT_EOE_SET_IP_PARAM_DEFAULT_GATEWAY_INCLUDED    0x00000008
#define ECAT_EOE_SET_IP_PARAM_DNS_SERVER_IP_ADDR_INCLUDED 0x00000010
#define ECAT_EOE_SET_IP_PARAM_DNS_NAME_INCLUDED           0x00000020

typedef struct ECAT_EOE_SET_IP_PARAM_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_EOE_SET_IP_PARAM_IND_DATA_T  tData;
} ECAT_EOE_SET_IP_PARAM_IND_T;

/* response packet */

typedef TLR_EMPTY_PACKET_T ECAT_EOE_SET_IP_PARAM_RES_T;

/******************************************************************************
 * Packet: ECAT_EOE_SET_IP_PARAM_IND/ECAT_EOE_SET_IP_PARAM_RES
 */

/* indication packet */

typedef TLR_EMPTY_PACKET_T ECAT_EOE_GET_IP_PARAM_IND_T;

/* response packet */

typedef __TLR_PACKED_PRE struct ECAT_EOE_GET_IP_PARAM_RES_DATA_Ttag
{
  TLR_UINT32              ulFlags;
  TLR_UINT8               abMacAddr[6];                 /* only valid if ECAT_EOE_SET_IP_PARAM_MAC_ADDRESS_INCLUDED         set in ulFlags */
  TLR_UINT8               abIpAddr[4];                  /* only valid if ECAT_EOE_SET_IP_PARAM_IP_ADDRESS_INCLUDED          set in ulFlags */
  TLR_UINT8               abSubnetMask[4];              /* only valid if ECAT_EOE_SET_IP_PARAM_SUBNET_MASK_INCLUDED         set in ulFlags */
  TLR_UINT8               abDefaultGateway[4];          /* only valid if ECAT_EOE_SET_IP_PARAM_DEFAULT_GATEWAY_INCLUDED     set in ulFlags */
  TLR_UINT8               abDnsServerIpAddress[4];      /* only valid if ECAT_EOE_SET_IP_PARAM_DNS_SERVER_IP_ADDR_INCLUDED  set in ulFlags */
  TLR_STR                 abDnsName[32];                /* only valid if ECAT_EOE_SET_IP_PARAM_DNS_NAME_INCLUDED            set in ulFlags */
} __TLR_PACKED_POST ECAT_EOE_GET_IP_PARAM_RES_DATA_T;

#define ECAT_EOE_GET_IP_PARAM_MAC_ADDRESS_INCLUDED        0x00000001
#define ECAT_EOE_GET_IP_PARAM_IP_ADDRESS_INCLUDED         0x00000002
#define ECAT_EOE_GET_IP_PARAM_SUBNET_MASK_INCLUDED        0x00000004
#define ECAT_EOE_GET_IP_PARAM_DEFAULT_GATEWAY_INCLUDED    0x00000008
#define ECAT_EOE_GET_IP_PARAM_DNS_SERVER_IP_ADDR_INCLUDED 0x00000010
#define ECAT_EOE_GET_IP_PARAM_DNS_NAME_INCLUDED           0x00000020

typedef struct ECAT_EOE_GET_IP_PARAM_RES_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_EOE_GET_IP_PARAM_RES_DATA_T  tData;
} ECAT_EOE_GET_IP_PARAM_RES_T;

/******************************************************************************
 * Packet: ECAT_EOE_SET_TIMEOUTS_REQ/ECAT_EOE_SET_TIMEOUTS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_EOE_SET_TIMEOUTS_REQ_DATA_Ttag
{
  /* Frame timer granularity */
  TLR_UINT                      ulTimerGran;
  /* Frame timeout */
  TLR_UINT                      ulFrameTimeout;
} __TLR_PACKED_POST ECAT_EOE_SET_TIMEOUTS_REQ_DATA_T;

typedef struct ECAT_EOE_SET_TIMEOUTS_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_EOE_SET_TIMEOUTS_REQ_DATA_T  tData;
} ECAT_EOE_SET_TIMEOUTS_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_SET_TIMEOUTS_CNF_T;


/******************************************************************************
 * Packet: ECAT_EOE_GET_TIMEOUTS_REQ/ECAT_EOE_GET_TIMEOUTS_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T ECAT_EOE_GET_TIMEOUTS_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct ECAT_EOE_GET_TIMEOUTS_CNF_DATA_Ttag
{
  /* Frame timer granularity */
  TLR_UINT                      ulTimerGran;
  /* Frame timeout */
  TLR_UINT                      ulFrameTimeout;
} __TLR_PACKED_POST ECAT_EOE_GET_TIMEOUTS_CNF_DATA_T;

typedef struct ECAT_EOE_GET_TIMEOUTS_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_EOE_GET_TIMEOUTS_CNF_DATA_T  tData;
} ECAT_EOE_GET_TIMEOUTS_CNF_T;


/******************************************************************************
 * Packet: ECAT_EOE_FRAME_IND/ECAT_EOE_FRAME_RES/ECAT_EOE_FRAME_REQ/ECAT_EOE_FRAME_CNF
 */

#define ECAT_EOE_FRAME_DATA_SIZE 1504
#define ECAT_EOE_FRAME_HEADER_SIZE 14

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_EOE_FRAME_IND_DATA_Ttag
{
  /* flags associated with frame */
  TLR_UINT16            usFlags;
  /* port on which this has to be forwarded */
  TLR_UINT16            usPortNo;
  /* time stamp value */
  TLR_UINT32            ulTimestampNs;
  /* dest MAC address */
  TLR_UINT8             abDstMacAddr[6];
  /* source MAC address */
  TLR_UINT8             abSrcMacAddr[6];
  /* ether type in network byte order */
  TLR_UINT16            usEthType;
  /* abData (including VlanHeader if available (1500 bytes of data is max MTU of Ethernet)) */
  TLR_UINT8             abData[ECAT_EOE_FRAME_DATA_SIZE];
} __TLR_PACKED_POST ECAT_EOE_FRAME_IND_DATA_T;

#define ECAT_EOE_FRAME_FLAG_TIME_REQUEST        0x0001
#define ECAT_EOE_FRAME_FLAG_TIME_VALID          0x0002

typedef struct ECAT_EOE_FRAME_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  ECAT_EOE_FRAME_IND_DATA_T         tData;
} ECAT_EOE_FRAME_IND_T;
typedef ECAT_EOE_FRAME_IND_T ECAT_EOE_FRAME_REQ_T;

/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_EOE_FRAME_RES_DATA_Ttag
{
  TLR_UINT16            usFlags;        /* ECAT_EOE_FRAME_FLAG_TIME_VALID specifies whether ulTimestamp* contain valid data */
  TLR_UINT32            ulTimestampNs;
  TLR_UINT16            usFrameLen;
  /* this packet must be end before the original frame starts */
} __TLR_PACKED_POST ECAT_EOE_FRAME_RES_DATA_T;

typedef struct ECAT_EOE_FRAME_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  ECAT_EOE_FRAME_RES_DATA_T       tData;
} ECAT_EOE_FRAME_RES_T;

typedef ECAT_EOE_FRAME_RES_T ECAT_EOE_FRAME_CNF_T;

typedef union ECAT_EOE_FRAME_PCK_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_EOE_FRAME_REQ_T tFrameReq;
  ECAT_EOE_FRAME_CNF_T tFrameCnf;
} ECAT_EOE_FRAME_PCK_T;

#endif

#ifndef __ECAT_FOE_PUBLIC_H
#define __ECAT_FOE_PUBLIC_H

#define ECAT_FOE_PROCESS_QUEUE_NAME "ECAT_FOE_QUE"

#define ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ 0x9500
#define ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF 0x9501

#define ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ 0x9502
#define ECAT_FOE_UNREGISTER_FILE_INDICATIONS_CNF 0x9503

#define ECAT_FOE_WRITE_FILE_IND 0x9510
#define ECAT_FOE_WRITE_FILE_RES 0x9511

#define ECAT_FOE_READ_FILE_IND 0x9512
#define ECAT_FOE_READ_FILE_RES 0x9513

#define ECAT_FOE_FILE_WRITTEN_IND 0x9520
#define ECAT_FOE_FILE_WRITTEN_RES 0x9521

#define ECAT_FOE_FILE_WRITE_ABORTED_IND 0x9530
#define ECAT_FOE_FILE_WRITE_ABORTED_RES 0x9531

#define ECAT_FOE_MAX_FILE_NAME_LENGTH 256

/******************************************************************************
 * Packet:  ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ/ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF
 */

#define ECAT_FOE_INDICATION_TYPE_FILE_WRITTEN 1
#define ECAT_FOE_INDICATION_TYPE_ANY_FILE_WRITTEN 2
#define ECAT_FOE_INDICATION_TYPE_VIRTUAL_FILE 3
#define ECAT_FOE_INDICATION_TYPE_ANY_VIRTUAL_FILE 4 /* used for rcX File Handler */
#define ECAT_FOE_INDICATION_TYPE_ANY_FILE_WRITE_ABORTED 5

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8 bIndicationType;
  TLR_STR abFilename[ECAT_FOE_MAX_FILE_NAME_LENGTH];
} __TLR_PACKED_POST ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT8 bIndicationType;
  TLR_STR abFilename[ECAT_FOE_MAX_FILE_NAME_LENGTH];
} __TLR_PACKED_POST ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF_T;


/* packet union */
typedef union ECAT_FOE_REGISTER_FILE_INDICATIONS_PCK_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_REGISTER_FILE_INDICATIONS_REQ_T tReq;
  ECAT_FOE_REGISTER_FILE_INDICATIONS_CNF_T tCnf;
} ECAT_FOE_REGISTER_FILE_INDICATIONS_PCK_T;


/******************************************************************************
 * Packet:  ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ/ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT8 bIndicationType;
  TLR_STR abFilename[ECAT_FOE_MAX_FILE_NAME_LENGTH];
} __TLR_PACKED_POST ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_UNREGISTER_FILE_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} __TLR_PACKED_POST ECAT_FOE_UNREGISTER_FILE_INDICATIONS_CNF_T;


/* packet union */
typedef union ECAT_FOE_UNREGISTER_FILE_INDICATIONS_PCK_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_UNREGISTER_FILE_INDICATIONS_REQ_T tReq;
  ECAT_FOE_UNREGISTER_FILE_INDICATIONS_CNF_T tCnf;
} ECAT_FOE_UNREGISTER_FILE_INDICATIONS_PCK_T;


/******************************************************************************
 * Packet:  ECAT_FOE_WRITE_FILE_IND/ECAT_FOE_WRITE_FILE_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_WRITE_FILE_IND_DATA_Ttag
{
  TLR_UINT8 abData[1024]; /* may be larger depending on foreign queue size */
  /* first packet contains password and filename in abData, following packets have data */
  /* last segment is signaled when ulExt.Seq is set to LAST, can have zero bytes of data */
  /* middle segment is signaled when ulExt.Seq is set to MIDDLE */
} __TLR_PACKED_POST ECAT_FOE_WRITE_FILE_IND_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_WRITE_FILE_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_WRITE_FILE_IND_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_WRITE_FILE_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_WRITE_FILE_RES_DATA_Ttag
{
  TLR_UINT8 abText[1024]; /* only valid when packet status != 0 */
} __TLR_PACKED_POST ECAT_FOE_WRITE_FILE_RES_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_WRITE_FILE_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_WRITE_FILE_RES_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_WRITE_FILE_RES_T;


/* packet union */
typedef union ECAT_FOE_WRITE_FILE_PCK_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_WRITE_FILE_IND_T tInd;
  ECAT_FOE_WRITE_FILE_RES_T tRes;
} ECAT_FOE_WRITE_FILE_PCK_T;


/******************************************************************************
 * Packet:  ECAT_FOE_READ_FILE_IND/ECAT_FOE_READ_FILE_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_READ_FILE_IND_DATA_Ttag
{
  TLR_UINT32 ulMaximumByteSizeOfFragment; /* each packet fragment that is not marked LAST has to use this amount of data in its response handling */
  /* on MIDDLE segments, the packet will have ulLen set to 4 */
  TLR_UINT32 ulPassword;  /* only valid on first fragment */
  TLR_UINT8 abFilename[ECAT_FOE_MAX_FILE_NAME_LENGTH]; /* only valid on first fragment */
} __TLR_PACKED_POST ECAT_FOE_READ_FILE_IND_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_READ_FILE_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_READ_FILE_IND_DATA_T tData; /* only valid on first fragment, following fragments have ulLen set to 0 */
} __TLR_PACKED_POST ECAT_FOE_READ_FILE_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_READ_FILE_RES_DATA_Ttag
{
  TLR_UINT8 abData[1600]; /* actual size depends on ulLen */
  /* last segment is signaled when length is smaller than ulMaximumByteSizeOfFragment and it is expected to have ulExt.Seq set to LAST */
  /* middle segment is signaled when length is equal to ulMaximumByteSizeOfFragment and it is expected to have ulExt.Seq set to MIDDLE */

  /* in case of error, this field is used for communicating the error string */
} __TLR_PACKED_POST ECAT_FOE_READ_FILE_RES_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_READ_FILE_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_READ_FILE_RES_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_READ_FILE_RES_T;


/* packet union */
typedef union ECAT_FOE_READ_FILE_PCK_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_READ_FILE_IND_T tInd;
  ECAT_FOE_READ_FILE_RES_T tRes;
} ECAT_FOE_READ_FILE_PCK_T;


/******************************************************************************
 * Packet:  ECAT_FOE_FILE_WRITTEN_IND/ECAT_FOE_FILE_WRITTEN_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_FILE_WRITTEN_IND_DATA_Ttag
{
  TLR_UINT8 abFilename[ECAT_FOE_MAX_FILE_NAME_LENGTH];
} __TLR_PACKED_POST ECAT_FOE_FILE_WRITTEN_IND_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_FILE_WRITTEN_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_FILE_WRITTEN_IND_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_FILE_WRITTEN_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_FILE_WRITTEN_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} __TLR_PACKED_POST ECAT_FOE_FILE_WRITTEN_RES_T;


/* packet union */
typedef union ECAT_FOE_FILE_WRITTEN_PCK_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_FILE_WRITTEN_IND_T tInd;
  ECAT_FOE_FILE_WRITTEN_RES_T tRes;
} ECAT_FOE_FILE_WRITTEN_PCK_T;

/******************************************************************************
 * Packet:  ECAT_FOE_FILE_WRITTE_ABORTED_IND/ECAT_FOE_FILE_WRITTE_ABORTED_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_FILE_WRITE_ABORTED_IND_DATA_Ttag
{
  TLR_UINT8 abFilename[ECAT_FOE_MAX_FILE_NAME_LENGTH];
} __TLR_PACKED_POST ECAT_FOE_FILE_WRITE_ABORTED_IND_DATA_T;

typedef __TLR_PACKED_PRE struct ECAT_FOE_FILE_WRITE_ABORTED_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_FILE_WRITE_ABORTED_IND_DATA_T tData;
} __TLR_PACKED_POST ECAT_FOE_FILE_WRITE_ABORTED_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct ECAT_FOE_FILE_WRITE_ABORTED_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} __TLR_PACKED_POST ECAT_FOE_FILE_WRITE_ABORTED_RES_T;


/* packet union */
typedef union ECAT_FOE_FILE_WRITE_ABORTED_PCK_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  ECAT_FOE_FILE_WRITE_ABORTED_IND_T tInd;
  ECAT_FOE_FILE_WRITE_ABORTED_RES_T tRes;
} ECAT_FOE_FILE_WRITE_ABORTED_PCK_T;


#endif //__ECAT_FOE_PUBLIC_H
